/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.stats.Stats;
import org.opensearch.timeseries.transport.StatsNodeRequest;
import org.opensearch.timeseries.transport.StatsNodeResponse;
import org.opensearch.timeseries.transport.StatsNodesResponse;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.transport.TransportService;

public class BaseStatsNodesTransportAction
extends TransportNodesAction<StatsRequest, StatsNodesResponse, StatsNodeRequest, StatsNodeResponse> {
    private Stats stats;

    public BaseStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Stats stats, String statsNodesActionName) {
        super(statsNodesActionName, threadPool, clusterService, transportService, actionFilters, StatsRequest::new, StatsNodeRequest::new, "management", StatsNodeResponse.class);
        this.stats = stats;
    }

    protected StatsNodesResponse newResponse(StatsRequest request, List<StatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new StatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected StatsNodeRequest newNodeRequest(StatsRequest request) {
        return new StatsNodeRequest(request);
    }

    protected StatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new StatsNodeResponse(in);
    }

    protected StatsNodeResponse nodeOperation(StatsNodeRequest request) {
        return this.createADStatsNodeResponse(request.getADStatsRequest());
    }

    protected StatsNodeResponse createADStatsNodeResponse(StatsRequest statsRequest) {
        HashMap<String, Object> statValues = new HashMap<String, Object>();
        Set<String> statsToBeRetrieved = statsRequest.getStatsToBeRetrieved();
        for (String statName : this.stats.getNodeStats().keySet()) {
            if (!statsToBeRetrieved.contains(statName)) continue;
            statValues.put(statName, this.stats.getStats().get(statName).getValue());
        }
        return new StatsNodeResponse(this.clusterService.localNode(), statValues);
    }
}

