/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.settings;

import java.time.Duration;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;

public class TimeSeriesSettings {
    public static final int DEFAULT_SHINGLE_SIZE = 8;
    public static final int MAX_SHINGLE_SIZE = 128;
    public static final int SEASONALITY_TO_SHINGLE_RATIO = 2;
    public static final String CONFIG_INDEX_MAPPING_FILE = "mappings/config.json";
    public static final String JOBS_INDEX_MAPPING_FILE = "mappings/job.json";
    public static final int DOOR_KEEPER_FOR_COLD_STARTER_MAX_INSERTION = 100000;
    public static final int EXPIRING_VALUE_MAINTENANCE_FREQ = 60;
    public static final int DOOR_KEEPER_FOR_CACHE_MAX_INSERTION = 1000000;
    public static final double REAL_TIME_BOUNDING_BOX_CACHE_RATIO = 0.0;
    public static final int MAX_HISTORY_INTERVALS = 10000;
    public static final int MAX_BATCH_TASK_PIECE_SIZE = 10000;
    public static final Duration HOURLY_MAINTENANCE = Duration.ofHours(1L);
    public static final Setting<Integer> MAX_CACHED_DELETED_TASKS = Setting.intSetting((String)"plugins.timeseries.max_cached_deleted_tasks", (int)1000, (int)1, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final int MAX_CHECKPOINT_BYTES = 30000000;
    public static final int MAX_TOTAL_RCF_SERIALIZATION_BUFFERS = 20;
    public static final int SERIALIZATION_BUFFER_BYTES = 512;
    public static int CHECKPOINT_WRITE_QUEUE_SIZE_IN_BYTES = 200000;
    public static int RESULT_WRITE_QUEUE_SIZE_IN_BYTES = 1160;
    public static int FEATURE_REQUEST_SIZE_IN_BYTES = 812;
    public static int CHECKPOINT_MAINTAIN_REQUEST_SIZE_IN_BYTES = 416;
    public static final float MAX_QUEUED_TASKS_RATIO = 0.5f;
    public static final float MEDIUM_SEGMENT_PRUNE_RATIO = 0.1f;
    public static final float LOW_SEGMENT_PRUNE_RATIO = 0.3f;
    public static final int MAINTENANCE_FREQ_CONSTANT = 10000;
    public static final Duration QUEUE_MAINTENANCE = Duration.ofMinutes(10L);
    public static final int NUM_SAMPLES_PER_TREE = 256;
    public static final int NUM_TREES = 50;
    public static final int DEFAULT_RECENCY_EMPHASIS = 2560;
    public static final int NUM_MIN_SAMPLES = 32;
    public static final double BATCH_BOUNDING_BOX_CACHE_RATIO = 1.0;
    public static final int TRAIN_SAMPLE_TIME_RANGE_IN_HOURS = 24;
    public static final int MIN_TRAIN_SAMPLES = 512;
    public static int MAX_COLD_START_ROUNDS = 2;
    public static final double THRESHOLD_MIN_PVALUE = 0.995;
    public static final Setting<Integer> MAX_RETRY_FOR_UNRESPONSIVE_NODE = Setting.intSetting((String)"plugins.timeseries.max_retry_for_unresponsive_node", (int)5, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> BACKOFF_MINUTES = Setting.positiveTimeSetting((String)"plugins.timeseries.backoff_minutes", (TimeValue)TimeValue.timeValueMinutes((long)15L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> COOLDOWN_MINUTES = Setting.positiveTimeSetting((String)"plugins.timeseries.cooldown_minutes", (TimeValue)TimeValue.timeValueMinutes((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static int MAX_UPDATE_RETRY_TIMES = 10000;
    public static final long DEFAULT_JOB_LOC_DURATION_SECONDS = 60L;
    public static final int MAX_TOTAL_ENTITIES_TO_TRACK = 10000;
    public static final long TOP_VALIDATE_TIMEOUT_IN_MILLIS = 10000L;
    public static final double INTERVAL_BUCKET_MINIMUM_SUCCESS_RATE = 0.75;
    public static final double INTERVAL_RECOMMENDATION_INCREASING_MULTIPLIER = 1.2;
    public static final long MAX_INTERVAL_REC_LENGTH_IN_MINUTES = 60L;
    public static final int MAX_DESCRIPTION_LENGTH = 1000;
    public static final int COLD_START_DOOR_KEEPER_COUNT_THRESHOLD = 3;
    public static final int CACHE_DOOR_KEEPER_COUNT_THRESHOLD = 1;
    public static final int MAX_TRACKING_ENTITIES = 1000000;
}

