/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest.handler;

import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.forecast.ExecuteForecastResultResponseRecorder;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.forecast.model.ForecastTaskType;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.forecast.transport.ForecastProfileAction;
import org.opensearch.forecast.transport.ForecastResultAction;
import org.opensearch.forecast.transport.ForecastResultRequest;
import org.opensearch.forecast.transport.StopForecasterAction;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.rest.handler.IndexJobActionHandler;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.JobResponse;
import org.opensearch.timeseries.transport.ResultRequest;
import org.opensearch.transport.TransportService;

public class ForecastIndexJobActionHandler
extends IndexJobActionHandler<ForecastIndex, ForecastIndexManagement, TaskCacheManager, ForecastTaskType, ForecastTask, ForecastTaskManager, ForecastResult, ForecastProfileAction, ExecuteForecastResultResponseRecorder> {
    public ForecastIndexJobActionHandler(Client client, ForecastIndexManagement indexManagement, NamedXContentRegistry xContentRegistry, ForecastTaskManager adTaskManager, ExecuteForecastResultResponseRecorder recorder, NodeStateManager nodeStateManager, Settings settings) {
        super(client, indexManagement, xContentRegistry, adTaskManager, recorder, ForecastResultAction.INSTANCE, AnalysisType.FORECAST, ForecastIndex.STATE.getIndexName(), StopForecasterAction.INSTANCE, nodeStateManager, settings, ForecastSettings.FORECAST_REQUEST_TIMEOUT);
    }

    @Override
    protected ResultRequest createResultRequest(String configID, long start, long end) {
        return new ForecastResultRequest(configID, start, end);
    }

    @Override
    protected List<ForecastTaskType> getBatchConfigTaskTypes() {
        return ForecastTaskType.RUN_ONCE_TASK_TYPES;
    }

    @Override
    public void stopConfig(String configId, boolean historical, User user, TransportService transportService, ActionListener<JobResponse> listener) {
        this.nodeStateManager.getConfig(configId, AnalysisType.FORECAST, config -> {
            if (!config.isPresent()) {
                listener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FAIL_TO_FIND_CONFIG_MSG + configId, RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            ((ForecastTaskManager)this.taskManager).getAndExecuteOnLatestConfigLevelTask(configId, ForecastTaskType.RUN_ONCE_TASK_TYPES, task -> this.stopJob(configId, transportService, listener), transportService, true, listener);
        }, listener);
    }
}

