/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.rest.AbstractForecasterAction;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.ValidateForecasterAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.model.ConfigValidationIssue;
import org.opensearch.timeseries.rest.RestValidateAction;
import org.opensearch.timeseries.transport.ValidateConfigRequest;
import org.owasp.encoder.Encode;

public class RestValidateForecasterAction
extends AbstractForecasterAction {
    private static final String VALIDATE_FORECASTER_ACTION = "validate_forecaster_action";
    private RestValidateAction validateAction;

    public RestValidateForecasterAction(Settings settings, ClusterService clusterService) {
        super(settings, clusterService);
        this.validateAction = new RestValidateAction(AnalysisType.FORECAST, this.maxSingleStreamForecasters, this.maxHCForecasters, this.maxForecastFeatures, this.maxCategoricalFields, this.requestTimeout);
    }

    public String getName() {
        return VALIDATE_FORECASTER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s", "/_plugins/_forecast/forecasters", "_validate")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_forecast/forecasters", "_validate", "type")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            String typesStr = request.param("type");
            return channel -> {
                try {
                    ValidateConfigRequest validateForecasterRequest = this.validateAction.prepareRequest(request, client, typesStr);
                    client.execute((ActionType)ValidateForecasterAction.INSTANCE, (ActionRequest)validateForecasterRequest, (ActionListener)new RestToXContentListener(channel));
                }
                catch (Exception ex) {
                    if (ex instanceof ValidationException) {
                        ValidationException forecastException = (ValidationException)ex;
                        ConfigValidationIssue issue = new ConfigValidationIssue(forecastException.getAspect(), forecastException.getType(), forecastException.getMessage());
                        this.validateAction.sendValidationParseResponse(issue, (RestChannel)channel);
                    }
                    throw ex;
                }
            };
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }
}

