/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.SearchTopForecastResultAction;
import org.opensearch.forecast.transport.SearchTopForecastResultRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.owasp.encoder.Encode;

public class RestSearchTopForecastResultAction
extends BaseRestHandler {
    private static final String URL_PATH = String.format(Locale.ROOT, "%s/{%s}/%s/%s", "/_plugins/_forecast/forecasters", "forecasterID", "results", "_topForecasts");
    private final String SEARCH_TOP_FORECASTS_ACTION = "search_top_forecasts";

    public String getName() {
        return "search_top_forecasts";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            SearchTopForecastResultRequest searchTopAnomalyResultRequest = this.getSearchTopForecastResultRequest(request);
            return channel -> client.execute((ActionType)SearchTopForecastResultAction.INSTANCE, (ActionRequest)searchTopAnomalyResultRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    private SearchTopForecastResultRequest getSearchTopForecastResultRequest(RestRequest request) throws IOException {
        if (!request.hasParam("forecasterID")) {
            throw new IllegalStateException("Forecaster ID is missing");
        }
        String forecasterId = request.param("forecasterID");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return SearchTopForecastResultRequest.parse(parser, forecasterId);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, URL_PATH), (Object)new RestHandler.Route(RestRequest.Method.GET, URL_PATH));
    }
}

