/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest.handler;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.rest.handler.ADModelValidationActionHandler;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.IndexAnomalyDetectorResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.RestRequest;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.rest.handler.AbstractTimeSeriesActionHandler;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;

public abstract class AbstractAnomalyDetectorActionHandler<T extends ActionResponse>
extends AbstractTimeSeriesActionHandler<T, ADIndex, ADIndexManagement, ADTaskCacheManager, ADTaskType, ADTask, ADTaskManager> {
    protected final Logger logger = LogManager.getLogger(AbstractAnomalyDetectorActionHandler.class);
    public static final String EXCEEDED_MAX_HC_DETECTORS_PREFIX_MSG = "Can't create more than %d HC anomaly detectors.";
    public static final String EXCEEDED_MAX_SINGLE_STREAM_DETECTORS_PREFIX_MSG = "Can't create more than %d single-stream anomaly detectors.";
    public static final String NO_DOCS_IN_USER_INDEX_MSG = "Can't create anomaly detector as no document is found in the indices: %s";
    public static final String DUPLICATE_DETECTOR_MSG = "Cannot create anomaly detector with name [%s] as it's already used by another detector";
    public static final String VALIDATION_FEATURE_FAILURE = "Validation failed for feature(s) of detector %s";

    public AbstractAnomalyDetectorActionHandler(ClusterService clusterService, Client client, SecurityClientUtil clientUtil, TransportService transportService, ADIndexManagement anomalyDetectionIndices, String detectorId, Long seqNo, Long primaryTerm, WriteRequest.RefreshPolicy refreshPolicy, Config anomalyDetector, TimeValue requestTimeout, Integer maxSingleStreamAnomalyDetectors, Integer maxHCAnomalyDetectors, Integer maxFeatures, Integer maxCategoricalFields, RestRequest.Method method, NamedXContentRegistry xContentRegistry, User user, ADTaskManager adTaskManager, SearchFeatureDao searchFeatureDao, String validationType, boolean isDryRun, Clock clock, Settings settings) {
        super(anomalyDetector, anomalyDetectionIndices, isDryRun, client, detectorId, clientUtil, user, method, clusterService, xContentRegistry, transportService, requestTimeout, refreshPolicy, seqNo, primaryTerm, validationType, searchFeatureDao, maxFeatures, maxCategoricalFields, AnalysisType.AD, adTaskManager, ADTaskType.HISTORICAL_DETECTOR_TASK_TYPES, false, maxSingleStreamAnomalyDetectors, maxHCAnomalyDetectors, clock, settings, ValidationAspect.DETECTOR);
    }

    @Override
    protected TimeSeriesException createValidationException(String msg, ValidationIssueType type) {
        return new ValidationException(msg, type, ValidationAspect.DETECTOR);
    }

    @Override
    protected AnomalyDetector parse(XContentParser parser, GetResponse response) throws IOException {
        return AnomalyDetector.parse(parser, response.getId(), response.getVersion());
    }

    @Override
    protected String getExceedMaxSingleStreamConfigsErrorMsg(int maxSingleStreamConfigs) {
        return String.format(Locale.ROOT, EXCEEDED_MAX_SINGLE_STREAM_DETECTORS_PREFIX_MSG, this.getMaxSingleStreamConfigs());
    }

    @Override
    protected String getExceedMaxHCConfigsErrorMsg(int maxHCConfigs) {
        return String.format(Locale.ROOT, EXCEEDED_MAX_HC_DETECTORS_PREFIX_MSG, this.getMaxHCConfigs());
    }

    @Override
    protected String getNoDocsInUserIndexErrorMsg(String suppliedIndices) {
        return String.format(Locale.ROOT, NO_DOCS_IN_USER_INDEX_MSG, suppliedIndices);
    }

    @Override
    protected String getDuplicateConfigErrorMsg(String name) {
        return String.format(Locale.ROOT, DUPLICATE_DETECTOR_MSG, name);
    }

    @Override
    protected AnomalyDetector copyConfig(User user, Config config) {
        AnomalyDetector detector = (AnomalyDetector)config;
        return new AnomalyDetector(config.getId(), config.getVersion(), config.getName(), config.getDescription(), config.getTimeField(), config.getIndices(), config.getFeatureAttributes(), config.getFilterQuery(), config.getInterval(), config.getWindowDelay(), config.getShingleSize(), config.getUiMetadata(), config.getSchemaVersion(), Instant.now(), config.getCategoryFields(), user, config.getCustomResultIndexOrAlias(), config.getImputationOption(), config.getRecencyEmphasis(), config.getSeasonIntervals(), config.getHistoryIntervals(), detector.getRules(), config.getCustomResultIndexMinSize(), config.getCustomResultIndexMinAge(), config.getCustomResultIndexTTL(), this.breakingUIChange ? Instant.now() : config.getLastBreakingUIChangeTime());
    }

    @Override
    protected T createIndexConfigResponse(IndexResponse indexResponse, Config config) {
        return (T)((Object)new IndexAnomalyDetectorResponse(indexResponse.getId(), indexResponse.getVersion(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), (AnomalyDetector)config, RestStatus.CREATED));
    }

    @Override
    protected Set<ValidationAspect> getDefaultValidationType() {
        return Sets.newHashSet((Object[])new ValidationAspect[]{ValidationAspect.DETECTOR});
    }

    @Override
    protected String getFeatureErrorMsg(String name) {
        return String.format(Locale.ROOT, VALIDATION_FEATURE_FAILURE, name);
    }

    @Override
    protected void validateModel(ActionListener<T> listener) {
        ADModelValidationActionHandler modelValidationActionHandler = new ADModelValidationActionHandler(this.clusterService, this.client, this.clientUtil, listener, (AnomalyDetector)this.config, this.requestTimeout, this.xContentRegistry, this.searchFeatureDao, this.validationType, this.clock, this.settings, this.user);
        modelValidationActionHandler.start();
    }
}

