/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model.destination;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.model.destination.Chime;
import org.opensearch.alerting.model.destination.CustomWebhook;
import org.opensearch.alerting.model.destination.DestinationContext;
import org.opensearch.alerting.model.destination.Slack;
import org.opensearch.alerting.model.destination.email.Email;
import org.opensearch.alerting.model.destination.email.EmailAccount;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.util.DestinationType;
import org.opensearch.alerting.util.destinationmigration.DestinationConversionUtils;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyChimeMessage;
import org.opensearch.commons.destination.message.LegacyCustomWebhookMessage;
import org.opensearch.commons.destination.message.LegacyEmailMessage;
import org.opensearch.commons.destination.message.LegacySlackMessage;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0081\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J \u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u000206J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u0016H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0018H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003J\t\u0010>\u001a\u00020\u0007H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\t\u0010@\u001a\u00020\u000bH\u00c6\u0003J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010B\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010C\u001a\u00020\u0010H\u00c6\u0003J\u0010\u0010D\u001a\u00020E2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0095\u0001\u0010F\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00c6\u0001J \u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0002J\u0013\u0010N\u001a\u00020M2\b\u0010O\u001a\u0004\u0018\u00010EH\u00d6\u0003J\u001a\u0010P\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010Q\u001a\u00020\u0003H\u0002J\t\u0010R\u001a\u00020\u0007H\u00d6\u0001J\t\u0010S\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010T\u001a\u00020H2\u0006\u0010I\u001a\u00020HJ\u0018\u0010T\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020KH\u0016J\u0016\u0010U\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020KJ\u000e\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006["}, d2={"Lorg/opensearch/alerting/model/destination/Destination;", "Lorg/opensearch/core/xcontent/ToXContent;", "id", "", "version", "", "schemaVersion", "", "seqNo", "primaryTerm", "type", "Lorg/opensearch/alerting/util/DestinationType;", "name", "user", "Lorg/opensearch/commons/authuser/User;", "lastUpdateTime", "Ljava/time/Instant;", "chime", "Lorg/opensearch/alerting/model/destination/Chime;", "slack", "Lorg/opensearch/alerting/model/destination/Slack;", "customWebhook", "Lorg/opensearch/alerting/model/destination/CustomWebhook;", "email", "Lorg/opensearch/alerting/model/destination/email/Email;", "(Ljava/lang/String;JIIILorg/opensearch/alerting/util/DestinationType;Ljava/lang/String;Lorg/opensearch/commons/authuser/User;Ljava/time/Instant;Lorg/opensearch/alerting/model/destination/Chime;Lorg/opensearch/alerting/model/destination/Slack;Lorg/opensearch/alerting/model/destination/CustomWebhook;Lorg/opensearch/alerting/model/destination/email/Email;)V", "getChime", "()Lorg/opensearch/alerting/model/destination/Chime;", "getCustomWebhook", "()Lorg/opensearch/alerting/model/destination/CustomWebhook;", "getEmail", "()Lorg/opensearch/alerting/model/destination/email/Email;", "getId", "()Ljava/lang/String;", "getLastUpdateTime", "()Ljava/time/Instant;", "getName", "getPrimaryTerm", "()I", "getSchemaVersion", "getSeqNo", "getSlack", "()Lorg/opensearch/alerting/model/destination/Slack;", "getType", "()Lorg/opensearch/alerting/util/DestinationType;", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getVersion", "()J", "buildLegacyBaseMessage", "Lorg/opensearch/commons/destination/message/LegacyBaseMessage;", "compiledSubject", "compiledMessage", "destinationCtx", "Lorg/opensearch/alerting/model/destination/DestinationContext;", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "constructResponseForDestinationType", "", "copy", "createXContentBuilder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "secure", "", "equals", "other", "getLegacyCustomWebhookMessageURL", "message", "hashCode", "toString", "toXContent", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nDestination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Destination.kt\norg/opensearch/alerting/model/destination/Destination\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n1#2:310\n*E\n"})
public final class Destination
implements ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    private final int schemaVersion;
    private final int seqNo;
    private final int primaryTerm;
    @NotNull
    private final DestinationType type;
    @NotNull
    private final String name;
    @Nullable
    private final User user;
    @NotNull
    private final Instant lastUpdateTime;
    @Nullable
    private final Chime chime;
    @Nullable
    private final Slack slack;
    @Nullable
    private final CustomWebhook customWebhook;
    @Nullable
    private final Email email;
    @NotNull
    public static final String DESTINATION = "destination";
    @NotNull
    public static final String ID_FIELD = "id";
    @NotNull
    public static final String TYPE_FIELD = "type";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    public static final int NO_SEQ_NO = 0;
    public static final int NO_PRIMARY_TERM = 0;
    @NotNull
    public static final String SCHEMA_VERSION = "schema_version";
    @NotNull
    public static final String SEQ_NO_FIELD = "seq_no";
    @NotNull
    public static final String PRIMARY_TERM_FIELD = "primary_term";
    @NotNull
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    @NotNull
    public static final String CHIME = "chime";
    @NotNull
    public static final String SLACK = "slack";
    @NotNull
    public static final String CUSTOMWEBHOOK = "custom_webhook";
    @NotNull
    public static final String EMAIL = "email";
    @NotNull
    public static final String TEST_ACTION = "test";
    private static final Logger logger = LogManager.getLogger(Destination.class);

    public Destination(@NotNull String id, long version, int schemaVersion, int seqNo, int primaryTerm, @NotNull DestinationType type, @NotNull String name, @Nullable User user, @NotNull Instant lastUpdateTime, @Nullable Chime chime, @Nullable Slack slack, @Nullable CustomWebhook customWebhook, @Nullable Email email) {
        Intrinsics.checkNotNullParameter((Object)id, (String)ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)TYPE_FIELD);
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        this.id = id;
        this.version = version;
        this.schemaVersion = schemaVersion;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.type = type;
        this.name = name;
        this.user = user;
        this.lastUpdateTime = lastUpdateTime;
        this.chime = chime;
        this.slack = slack;
        this.customWebhook = customWebhook;
        this.email = email;
    }

    public /* synthetic */ Destination(String string, long l, int n, int n2, int n3, DestinationType destinationType, String string2, User user, Instant instant, Chime chime, Slack slack, CustomWebhook customWebhook, Email email, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = NO_ID;
        }
        if ((n4 & 2) != 0) {
            l = 1L;
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(string, l, n, n2, n3, destinationType, string2, user, instant, chime, slack, customWebhook, email);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getVersion() {
        return this.version;
    }

    public final int getSchemaVersion() {
        return this.schemaVersion;
    }

    public final int getSeqNo() {
        return this.seqNo;
    }

    public final int getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final DestinationType getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    @NotNull
    public final Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Nullable
    public final Chime getChime() {
        return this.chime;
    }

    @Nullable
    public final Slack getSlack() {
        return this.slack;
    }

    @Nullable
    public final CustomWebhook getCustomWebhook() {
        return this.customWebhook;
    }

    @Nullable
    public final Email getEmail() {
        return this.email;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, true);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, false);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params, boolean secure) {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(DESTINATION);
        }
        builder.field(ID_FIELD, this.id).field(TYPE_FIELD, this.type.getValue()).field(NAME_FIELD, this.name);
        if (!secure) {
            IndexUtilsKt.optionalUserField((XContentBuilder)builder, (String)USER_FIELD, (User)this.user);
        }
        XContentBuilder xContentBuilder = builder.field(SCHEMA_VERSION, this.schemaVersion).field(SEQ_NO_FIELD, this.seqNo).field(PRIMARY_TERM_FIELD, this.primaryTerm);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(SCHEMA_VER\u2026_TERM_FIELD, primaryTerm)");
        IndexUtilsKt.optionalTimeField((XContentBuilder)xContentBuilder, (String)LAST_UPDATE_TIME_FIELD, (Instant)this.lastUpdateTime).field(this.type.getValue(), this.constructResponseForDestinationType(this.type));
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder2 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.endObject()");
        return xContentBuilder2;
    }

    @NotNull
    public final XContentBuilder toXContent(@NotNull XContentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        return this.toXContent(builder, params);
    }

    public final void writeTo(@NotNull StreamOutput out) throws IOException {
        block4: {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeLong(this.version);
            out.writeInt(this.schemaVersion);
            out.writeInt(this.seqNo);
            out.writeInt(this.primaryTerm);
            out.writeEnum((Enum)this.type);
            out.writeString(this.name);
            out.writeBoolean(this.user != null);
            User user = this.user;
            if (user != null) {
                user.writeTo(out);
            }
            out.writeInstant(this.lastUpdateTime);
            out.writeBoolean(this.chime != null);
            Chime chime = this.chime;
            if (chime != null) {
                chime.writeTo(out);
            }
            out.writeBoolean(this.slack != null);
            Slack slack = this.slack;
            if (slack != null) {
                slack.writeTo(out);
            }
            out.writeBoolean(this.customWebhook != null);
            CustomWebhook customWebhook = this.customWebhook;
            if (customWebhook != null) {
                customWebhook.writeTo(out);
            }
            out.writeBoolean(this.email != null);
            Email email = this.email;
            if (email == null) break block4;
            email.writeTo(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LegacyBaseMessage buildLegacyBaseMessage(@Nullable String compiledSubject, @NotNull String compiledMessage, @NotNull DestinationContext destinationCtx) {
        Intrinsics.checkNotNullParameter((Object)compiledMessage, (String)"compiledMessage");
        Intrinsics.checkNotNullParameter((Object)destinationCtx, (String)"destinationCtx");
        LegacyBaseMessage destinationMessage = null;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                Chime chime = this.chime;
                String messageContent = chime != null ? chime.constructMessageContent(compiledSubject, compiledMessage) : null;
                Chime chime2 = this.chime;
                LegacyChimeMessage legacyChimeMessage = new LegacyChimeMessage.Builder(this.name).withUrl(chime2 != null ? chime2.getUrl() : null).withMessage(messageContent).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacyChimeMessage, (String)"Builder(name)\n          \u2026                 .build()");
                destinationMessage = (LegacyBaseMessage)legacyChimeMessage;
                break;
            }
            case 2: {
                Slack slack = this.slack;
                String messageContent = slack != null ? slack.constructMessageContent(compiledSubject, compiledMessage) : null;
                Slack slack2 = this.slack;
                LegacySlackMessage legacySlackMessage = new LegacySlackMessage.Builder(this.name).withUrl(slack2 != null ? slack2.getUrl() : null).withMessage(messageContent).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacySlackMessage, (String)"Builder(name)\n          \u2026                 .build()");
                destinationMessage = (LegacyBaseMessage)legacySlackMessage;
                break;
            }
            case 3: {
                CustomWebhook customWebhook = this.customWebhook;
                LegacyCustomWebhookMessage legacyCustomWebhookMessage = new LegacyCustomWebhookMessage.Builder(this.name).withUrl(this.getLegacyCustomWebhookMessageURL(this.customWebhook, compiledMessage)).withHeaderParams(customWebhook != null ? customWebhook.getHeaderParams() : null).withMessage(compiledMessage).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacyCustomWebhookMessage, (String)"Builder(name)\n          \u2026(compiledMessage).build()");
                destinationMessage = (LegacyBaseMessage)legacyCustomWebhookMessage;
                break;
            }
            case 4: {
                String string;
                EmailAccount emailAccount = destinationCtx.getEmailAccount();
                EmailAccount emailAccount2 = emailAccount;
                EmailAccount emailAccount3 = emailAccount;
                EmailAccount emailAccount4 = emailAccount;
                LegacyEmailMessage.Builder builder = new LegacyEmailMessage.Builder(this.name).withAccountName(emailAccount2 != null ? emailAccount2.getName() : null).withHost(emailAccount3 != null ? emailAccount3.getHost() : null).withPort(emailAccount4 != null ? Integer.valueOf(emailAccount4.getPort()) : null);
                Object object = emailAccount;
                if (object != null && (object = object.getMethod()) != null) {
                    void it;
                    Object object2 = object;
                    LegacyEmailMessage.Builder builder2 = builder;
                    boolean bl = false;
                    string = DestinationConversionUtils.Companion.convertAlertingToNotificationMethodType((EmailAccount.MethodType)it).toString();
                    builder = builder2;
                } else {
                    string = null;
                }
                EmailAccount emailAccount5 = emailAccount;
                LegacyEmailMessage legacyEmailMessage = builder.withMethod(string).withFrom(emailAccount5 != null ? emailAccount5.getEmail() : null).withRecipients(destinationCtx.getRecipients()).withSubject(compiledSubject).withMessage(compiledMessage).build();
                Intrinsics.checkNotNullExpressionValue((Object)legacyEmailMessage, (String)"Builder(name)\n          \u2026(compiledMessage).build()");
                destinationMessage = (LegacyBaseMessage)legacyEmailMessage;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Destination type [" + this.type + "] for building legacy message");
            }
        }
        return destinationMessage;
    }

    private final Object constructResponseForDestinationType(DestinationType type) {
        String content = null;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object object = this.chime;
                content = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)object))) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 2: {
                Object object = this.slack;
                content = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)object))) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 3: {
                Object object = this.customWebhook;
                content = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)object))) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 4: {
                Object object = this.email;
                content = object != null && (object = OpenSearchExtensionsKt.convertToMap((ToXContent)((ToXContent)object))) != null ? object.get(type.getValue()) : null;
                break;
            }
            case 5: {
                content = "dummy";
            }
        }
        if (content == null) {
            throw new IllegalArgumentException("Content is NULL for destination type " + type.getValue());
        }
        return content;
    }

    private final String getLegacyCustomWebhookMessageURL(CustomWebhook customWebhook, String message) {
        CustomWebhook customWebhook2 = customWebhook;
        CustomWebhook customWebhook3 = customWebhook;
        CustomWebhook customWebhook4 = customWebhook;
        CustomWebhook customWebhook5 = customWebhook;
        CustomWebhook customWebhook6 = customWebhook;
        CustomWebhook customWebhook7 = customWebhook;
        String string = new LegacyCustomWebhookMessage.Builder(this.name).withUrl(customWebhook2 != null ? customWebhook2.getUrl() : null).withScheme(customWebhook3 != null ? customWebhook3.getScheme() : null).withHost(customWebhook4 != null ? customWebhook4.getHost() : null).withPort(customWebhook5 != null ? Integer.valueOf(customWebhook5.getPort()) : null).withPath(customWebhook6 != null ? customWebhook6.getPath() : null).withQueryParams(customWebhook7 != null ? customWebhook7.getQueryParams() : null).withMessage(message).build().getUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Builder(name)\n          \u2026  .build().uri.toString()");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.version;
    }

    public final int component3() {
        return this.schemaVersion;
    }

    public final int component4() {
        return this.seqNo;
    }

    public final int component5() {
        return this.primaryTerm;
    }

    @NotNull
    public final DestinationType component6() {
        return this.type;
    }

    @NotNull
    public final String component7() {
        return this.name;
    }

    @Nullable
    public final User component8() {
        return this.user;
    }

    @NotNull
    public final Instant component9() {
        return this.lastUpdateTime;
    }

    @Nullable
    public final Chime component10() {
        return this.chime;
    }

    @Nullable
    public final Slack component11() {
        return this.slack;
    }

    @Nullable
    public final CustomWebhook component12() {
        return this.customWebhook;
    }

    @Nullable
    public final Email component13() {
        return this.email;
    }

    @NotNull
    public final Destination copy(@NotNull String id, long version, int schemaVersion, int seqNo, int primaryTerm, @NotNull DestinationType type, @NotNull String name, @Nullable User user, @NotNull Instant lastUpdateTime, @Nullable Chime chime, @Nullable Slack slack, @Nullable CustomWebhook customWebhook, @Nullable Email email) {
        Intrinsics.checkNotNullParameter((Object)id, (String)ID_FIELD);
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)TYPE_FIELD);
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        return new Destination(id, version, schemaVersion, seqNo, primaryTerm, type, name, user, lastUpdateTime, chime, slack, customWebhook, email);
    }

    public static /* synthetic */ Destination copy$default(Destination destination, String string, long l, int n, int n2, int n3, DestinationType destinationType, String string2, User user, Instant instant, Chime chime, Slack slack, CustomWebhook customWebhook, Email email, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = destination.id;
        }
        if ((n4 & 2) != 0) {
            l = destination.version;
        }
        if ((n4 & 4) != 0) {
            n = destination.schemaVersion;
        }
        if ((n4 & 8) != 0) {
            n2 = destination.seqNo;
        }
        if ((n4 & 0x10) != 0) {
            n3 = destination.primaryTerm;
        }
        if ((n4 & 0x20) != 0) {
            destinationType = destination.type;
        }
        if ((n4 & 0x40) != 0) {
            string2 = destination.name;
        }
        if ((n4 & 0x80) != 0) {
            user = destination.user;
        }
        if ((n4 & 0x100) != 0) {
            instant = destination.lastUpdateTime;
        }
        if ((n4 & 0x200) != 0) {
            chime = destination.chime;
        }
        if ((n4 & 0x400) != 0) {
            slack = destination.slack;
        }
        if ((n4 & 0x800) != 0) {
            customWebhook = destination.customWebhook;
        }
        if ((n4 & 0x1000) != 0) {
            email = destination.email;
        }
        return destination.copy(string, l, n, n2, n3, destinationType, string2, user, instant, chime, slack, customWebhook, email);
    }

    @NotNull
    public String toString() {
        return "Destination(id=" + this.id + ", version=" + this.version + ", schemaVersion=" + this.schemaVersion + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", type=" + this.type + ", name=" + this.name + ", user=" + this.user + ", lastUpdateTime=" + this.lastUpdateTime + ", chime=" + this.chime + ", slack=" + this.slack + ", customWebhook=" + this.customWebhook + ", email=" + this.email + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.version);
        result = result * 31 + Integer.hashCode(this.schemaVersion);
        result = result * 31 + Integer.hashCode(this.seqNo);
        result = result * 31 + Integer.hashCode(this.primaryTerm);
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + this.lastUpdateTime.hashCode();
        result = result * 31 + (this.chime == null ? 0 : this.chime.hashCode());
        result = result * 31 + (this.slack == null ? 0 : this.slack.hashCode());
        result = result * 31 + (this.customWebhook == null ? 0 : this.customWebhook.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Destination)) {
            return false;
        }
        Destination destination = (Destination)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)destination.id)) {
            return false;
        }
        if (this.version != destination.version) {
            return false;
        }
        if (this.schemaVersion != destination.schemaVersion) {
            return false;
        }
        if (this.seqNo != destination.seqNo) {
            return false;
        }
        if (this.primaryTerm != destination.primaryTerm) {
            return false;
        }
        if (this.type != destination.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)destination.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)destination.user)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdateTime, (Object)destination.lastUpdateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.chime, (Object)destination.chime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.slack, (Object)destination.slack)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.customWebhook, (Object)destination.customWebhook)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.email, (Object)destination.email);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp, @NotNull String id, long version, int seqNo, int primaryTerm) throws IOException {
        return Companion.parse(xcp, id, version, seqNo, primaryTerm);
    }

    @JvmStatic
    @NotNull
    public static final Destination parseWithType(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parseWithType(xcp, id, version);
    }

    @JvmStatic
    @NotNull
    public static final Destination readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp, @NotNull String id, long version, int seqNo) throws IOException {
        return Companion.parse(xcp, id, version, seqNo);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parse(xcp, id, version);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Destination parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u00102\b\b\u0002\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\rH\u0007J$\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u0010H\u0007J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/opensearch/alerting/model/destination/Destination$Companion;", "", "()V", "CHIME", "", "CUSTOMWEBHOOK", "DESTINATION", "EMAIL", "ID_FIELD", "LAST_UPDATE_TIME_FIELD", "NAME_FIELD", "NO_ID", "NO_PRIMARY_TERM", "", "NO_SEQ_NO", "NO_VERSION", "", "PRIMARY_TERM_FIELD", "SCHEMA_VERSION", "SEQ_NO_FIELD", "SLACK", "TEST_ACTION", "TYPE_FIELD", "USER_FIELD", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "parse", "Lorg/opensearch/alerting/model/destination/Destination;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "version", "seqNo", "primaryTerm", "parseWithType", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nDestination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Destination.kt\norg/opensearch/alerting/model/destination/Destination$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n11335#2:310\n11670#2,3:311\n1#3:314\n*S KotlinDebug\n*F\n+ 1 Destination.kt\norg/opensearch/alerting/model/destination/Destination$Companion\n*L\n158#1:310\n158#1:311,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp, @NotNull String id, long version, int seqNo, int primaryTerm) throws IOException {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Destination.ID_FIELD);
            String name = null;
            User user = null;
            String type = null;
            Slack slack = null;
            Chime chime = null;
            CustomWebhook customWebhook = null;
            Email email = null;
            Instant lastUpdateTime = null;
            int schemaVersion = 0;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block24: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                block39: {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block39;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1684719674: {
                            if (string.equals(Destination.SCHEMA_VERSION)) {
                                n = 1;
                            }
                            break;
                        }
                        case 2020321370: {
                            if (string.equals(Destination.LAST_UPDATE_TIME_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 3556498: {
                            if (string.equals(Destination.TEST_ACTION)) {
                                n = 3;
                            }
                            break;
                        }
                        case 109518736: {
                            if (string.equals(Destination.SLACK)) {
                                n = 4;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals(Destination.NAME_FIELD)) {
                                n = 5;
                            }
                            break;
                        }
                        case 3575610: {
                            if (string.equals(Destination.TYPE_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 697640873: {
                            if (string.equals(Destination.CUSTOMWEBHOOK)) {
                                n = 7;
                            }
                            break;
                        }
                        case 3599307: {
                            if (string.equals(Destination.USER_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                        case 96619420: {
                            if (string.equals(Destination.EMAIL)) {
                                n = 9;
                            }
                            break;
                        }
                        case 94631228: {
                            if (string.equals(Destination.CHIME)) {
                                n = 10;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            continue block24;
                        }
                        case 5: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            continue block24;
                        }
                        case 8: {
                            user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                            continue block24;
                        }
                        case 6: {
                            void $this$mapTo$iv$iv;
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            DestinationType[] $this$map$iv = DestinationType.values();
                            boolean $i$f$map = false;
                            DestinationType[] destinationTypeArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            int n2 = ((void)$this$mapTo$iv$iv).length;
                            for (int i = 0; i < n2; ++i) {
                                void it;
                                void item$iv$iv;
                                void var27_26 = item$iv$iv = $this$mapTo$iv$iv[i];
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getValue());
                            }
                            List allowedTypes = (List)destination$iv$iv;
                            if (allowedTypes.contains(type)) continue block24;
                            throw new IllegalStateException("Type should be one of the " + allowedTypes);
                        }
                        case 2: {
                            lastUpdateTime = IndexUtilsKt.instant((XContentParser)xcp);
                            continue block24;
                        }
                        case 10: {
                            chime = Chime.Companion.parse(xcp);
                            continue block24;
                        }
                        case 4: {
                            slack = Slack.Companion.parse(xcp);
                            continue block24;
                        }
                        case 7: {
                            customWebhook = CustomWebhook.Companion.parse(xcp);
                            continue block24;
                        }
                        case 9: {
                            email = Email.Companion.parse(xcp);
                            continue block24;
                        }
                        case 1: {
                            schemaVersion = xcp.intValue();
                            continue block24;
                        }
                    }
                }
                xcp.skipChildren();
            }
            String string = type;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)Destination.TYPE_FIELD);
                string = null;
            }
            String string2 = string;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
            DestinationType destinationType = DestinationType.valueOf(string3);
            String string4 = name;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)Destination.NAME_FIELD);
                string4 = null;
            }
            if ((instant = lastUpdateTime) == null) {
                instant = Instant.now();
            }
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastUpdateTime ?: Instant.now()");
            Email email2 = email;
            CustomWebhook customWebhook2 = customWebhook;
            Slack slack2 = slack;
            Chime chime2 = chime;
            Instant instant2 = instant;
            User user2 = user;
            String string5 = string4;
            DestinationType destinationType2 = destinationType;
            int n = primaryTerm;
            int n3 = seqNo;
            int n4 = schemaVersion;
            long l = version;
            String string6 = id;
            return new Destination(string6, l, n4, n3, n, destinationType2, string5, user2, instant2, chime2, slack2, customWebhook2, email2);
        }

        public static /* synthetic */ Destination parse$default(Companion companion, XContentParser xContentParser, String string, long l, int n, int n2, int n3, Object object) throws IOException {
            if ((n3 & 2) != 0) {
                string = Destination.NO_ID;
            }
            if ((n3 & 4) != 0) {
                l = 1L;
            }
            if ((n3 & 8) != 0) {
                n = 0;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 0;
            }
            return companion.parse(xContentParser, string, l, n, n2);
        }

        @JvmStatic
        @NotNull
        public final Destination parseWithType(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Destination.ID_FIELD);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            Destination destination = org.opensearch.alerting.model.destination.Destination$Companion.parse$default(this, xcp, id, version, 0, 0, 24, null);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            return destination;
        }

        public static /* synthetic */ Destination parseWithType$default(Companion companion, XContentParser xContentParser, String string, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Destination.NO_ID;
            }
            if ((n & 4) != 0) {
                l = 1L;
            }
            return companion.parseWithType(xContentParser, string, l);
        }

        @JvmStatic
        @NotNull
        public final Destination readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            String string = sin.readString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
            long l = sin.readLong();
            int n = sin.readInt();
            int n2 = sin.readInt();
            int n3 = sin.readInt();
            Enum enum_ = sin.readEnum(DestinationType.class);
            Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(DestinationType::class.java)");
            DestinationType destinationType = (DestinationType)enum_;
            String string2 = sin.readString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
            User user = sin.readBoolean() ? new User(sin) : null;
            Instant instant = sin.readInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
            return new Destination(string, l, n, n2, n3, destinationType, string2, user, instant, Chime.Companion.readFrom(sin), Slack.Companion.readFrom(sin), CustomWebhook.Companion.readFrom(sin), Email.Companion.readFrom(sin));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp, @NotNull String id, long version, int seqNo) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Destination.ID_FIELD);
            return org.opensearch.alerting.model.destination.Destination$Companion.parse$default(this, xcp, id, version, seqNo, 0, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Destination.ID_FIELD);
            return org.opensearch.alerting.model.destination.Destination$Companion.parse$default(this, xcp, id, version, 0, 0, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)Destination.ID_FIELD);
            return org.opensearch.alerting.model.destination.Destination$Companion.parse$default(this, xcp, id, 0L, 0, 0, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Destination parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.alerting.model.destination.Destination$Companion.parse$default(this, xcp, null, 0L, 0, 0, 30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DestinationType.values().length];
            try {
                nArray[DestinationType.CHIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.SLACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.CUSTOM_WEBHOOK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.EMAIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DestinationType.TEST_ACTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

