/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.spi.MediaTypeProvider;

public final class MediaTypeRegistry {
    private static Map<String, MediaType> formatToMediaType = Map.of();
    private static Map<String, MediaType> typeWithSubtypeToMediaType = Map.of();
    private static Map<String, MediaType> knownStringsToMediaType = Map.of();
    private static MediaType DEFAULT_MEDIA_TYPE;
    public static final int GUESS_HEADER_LENGTH = 20;
    public static final MediaType JSON;

    private static void register(MediaType[] acceptedMediaTypes, Map<String, MediaType> additionalMediaTypes) {
        HashMap<String, MediaType> typeMap = new HashMap<String, MediaType>(typeWithSubtypeToMediaType);
        HashMap<String, MediaType> formatMap = new HashMap<String, MediaType>(formatToMediaType);
        HashMap<String, MediaType> knownStringMap = new HashMap<String, MediaType>(knownStringsToMediaType);
        for (MediaType mediaType : acceptedMediaTypes) {
            if (formatMap.containsKey(mediaType.format())) {
                throw new IllegalArgumentException("unable to register mediaType: [" + mediaType.format() + "]. Type already exists.");
            }
            typeMap.put(mediaType.typeWithSubtype(), mediaType);
            formatMap.put(mediaType.format(), mediaType);
        }
        for (Map.Entry entry : additionalMediaTypes.entrySet()) {
            MediaType mediaType;
            String typeWithSubtype = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            if (typeMap.containsKey(typeWithSubtype)) {
                throw new IllegalArgumentException("unable to register mediaType: [" + (String)entry.getKey() + "]. Type already exists and is mapped to: [." + ((MediaType)entry.getValue()).format() + "]");
            }
            mediaType = (MediaType)entry.getValue();
            typeMap.put(typeWithSubtype, mediaType);
            formatMap.putIfAbsent(mediaType.format(), mediaType);
            knownStringMap.put(mediaType.mediaType(), mediaType);
            knownStringMap.put(mediaType.mediaTypeWithoutParameters(), mediaType);
        }
        formatToMediaType = Map.copyOf(formatMap);
        typeWithSubtypeToMediaType = Map.copyOf(typeMap);
        knownStringsToMediaType = Map.copyOf(knownStringMap);
    }

    public static MediaType fromMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        MediaType knownMediaType = knownStringsToMediaType.get(mediaType);
        if (knownMediaType != null) {
            return knownMediaType;
        }
        ParsedMediaType parsedMediaType = MediaTypeRegistry.parseMediaType(mediaType);
        return parsedMediaType != null ? parsedMediaType.getMediaType() : null;
    }

    public static MediaType fromFormat(String format) {
        if (format == null) {
            return null;
        }
        return formatToMediaType.get(format.toLowerCase(Locale.ROOT));
    }

    public static XContentBuilder contentBuilder(MediaType type) throws IOException {
        for (MediaType mediaType : formatToMediaType.values()) {
            if (type != mediaType) continue;
            return type.contentBuilder();
        }
        throw new IllegalArgumentException("No matching content type for " + type);
    }

    public static XContentBuilder contentBuilder(MediaType type, OutputStream outputStream) throws IOException {
        for (MediaType mediaType : formatToMediaType.values()) {
            if (type != mediaType) continue;
            return type.contentBuilder(outputStream);
        }
        throw new IllegalArgumentException("No matching content type for " + type);
    }

    @Deprecated
    public static MediaType xContent(byte[] data, int offset, int length) {
        MediaType type = MediaTypeRegistry.mediaTypeFromBytes(data, offset, length);
        if (type == null) {
            throw new XContentParseException("Failed to derive xcontent");
        }
        return type;
    }

    @Deprecated
    public static MediaType xContent(byte[] data) {
        return MediaTypeRegistry.xContent(data, 0, data.length);
    }

    @Deprecated
    public static MediaType xContent(CharSequence content) {
        MediaType type = MediaTypeRegistry.xContentType(content);
        if (type == null) {
            throw new XContentParseException("Failed to derive xcontent");
        }
        return type;
    }

    @Deprecated
    public static MediaType xContentType(CharSequence content) {
        int length;
        int n = length = content.length() < 20 ? content.length() : 20;
        if (length == 0) {
            return null;
        }
        for (MediaType mediaType : formatToMediaType.values()) {
            if (!mediaType.detectedXContent(content, length)) continue;
            return mediaType;
        }
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                return MediaType.fromMediaType("application/json");
            }
            if (!Character.isWhitespace(c)) break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MediaType xContentType(InputStream si) throws IOException {
        if (!si.markSupported()) {
            throw new IllegalArgumentException("Cannot guess the xcontent type without mark/reset support on " + si.getClass());
        }
        si.mark(Integer.MAX_VALUE);
        try {
            int read;
            int r;
            int current;
            do {
                if ((current = si.read()) != -1) continue;
                MediaType mediaType = null;
                return mediaType;
            } while (Character.isWhitespace((char)current));
            byte[] firstBytes = new byte[20];
            firstBytes[0] = (byte)current;
            for (read = 1; read < 20 && (r = si.read(firstBytes, read, 20 - read)) != -1; read += r) {
            }
            MediaType mediaType = MediaTypeRegistry.mediaTypeFromBytes(firstBytes, 0, read);
            return mediaType;
        }
        finally {
            si.reset();
        }
    }

    @Deprecated
    public static MediaType xContentType(BytesReference bytes) {
        if (bytes instanceof BytesArray) {
            BytesArray array = (BytesArray)bytes;
            return MediaTypeRegistry.mediaTypeFromBytes(array.array(), array.offset(), array.length());
        }
        try {
            StreamInput inputStream = bytes.streamInput();
            assert (inputStream.markSupported());
            return MediaTypeRegistry.xContentType(inputStream);
        }
        catch (IOException e) {
            assert (false) : "Should not happen, we're just reading bytes from memory";
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public static MediaType mediaTypeFromBytes(byte[] data, int offset, int length) {
        int totalLength = data.length;
        if (totalLength == 0 || length == 0) {
            return null;
        }
        if (offset + length > totalLength) {
            return null;
        }
        for (MediaType mediaType : formatToMediaType.values()) {
            if (!mediaType.detectedXContent(data, offset, length)) continue;
            return mediaType;
        }
        int jsonStart = 0;
        if (length > 3 && data[offset] == -17 && data[offset + 1] == -69 && data[offset + 2] == -65) {
            jsonStart = 3;
        }
        for (int i = jsonStart; i < length; ++i) {
            byte b = data[offset + i];
            if (b == 123) {
                return MediaTypeRegistry.fromMediaType("application/json");
            }
            if (!Character.isWhitespace(b)) break;
        }
        return null;
    }

    public static ParsedMediaType parseMediaType(String headerValue) {
        String subtype;
        String type;
        MediaType mediaType;
        String[] split;
        String[] typeSubtype;
        if (headerValue != null && (typeSubtype = (split = headerValue.toLowerCase(Locale.ROOT).split(";"))[0].trim().split("/")).length == 2 && (mediaType = typeWithSubtypeToMediaType.get((type = typeSubtype[0]) + "/" + (subtype = typeSubtype[1]))) != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (int i = 1; i < split.length; ++i) {
                String[] keyValueParam = split[i].trim().split("=");
                if (keyValueParam.length != 2 || MediaTypeRegistry.hasSpaces(keyValueParam[0]) || MediaTypeRegistry.hasSpaces(keyValueParam[1])) {
                    return null;
                }
                parameters.put(keyValueParam[0], keyValueParam[1]);
            }
            return new ParsedMediaType(mediaType, parameters);
        }
        return null;
    }

    private static boolean hasSpaces(String s) {
        return !s.trim().equals(s);
    }

    private static void setDefaultMediaType(MediaType mediaType) {
        if (DEFAULT_MEDIA_TYPE != null) {
            throw new RuntimeException("unable to reset the default media type from current default [" + DEFAULT_MEDIA_TYPE + "] to [" + mediaType + "]");
        }
        DEFAULT_MEDIA_TYPE = mediaType;
    }

    public static MediaType getDefaultMediaType() {
        return DEFAULT_MEDIA_TYPE;
    }

    static {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        Map<String, MediaType> amt = new HashMap<String, MediaType>();
        for (MediaTypeProvider provider : ServiceLoader.load(MediaTypeProvider.class, MediaTypeProvider.class.getClassLoader())) {
            mediaTypes.addAll(provider.getMediaTypes());
            amt = Stream.of(amt, provider.getAdditionalMediaTypes()).flatMap(map -> map.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        MediaTypeRegistry.register(mediaTypes.toArray(new MediaType[0]), amt);
        JSON = MediaTypeRegistry.fromMediaType("application/json");
        MediaTypeRegistry.setDefaultMediaType(JSON);
    }

    public static class ParsedMediaType {
        private final Map<String, String> parameters;
        private final MediaType mediaType;

        public ParsedMediaType(MediaType mediaType, Map<String, String> parameters) {
            this.parameters = parameters;
            this.mediaType = mediaType;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

