/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.common.policy;

import java.util.function.Function;
import java.util.function.Predicate;
import org.opensearch.cache.common.tier.TieredSpilloverCacheSettings;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.policy.CachedQueryResult;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;

public class TookTimePolicy<V>
implements Predicate<V> {
    private TimeValue threshold;
    private final Function<V, CachedQueryResult.PolicyValues> cachedResultParser;

    public TookTimePolicy(TimeValue threshold, Function<V, CachedQueryResult.PolicyValues> cachedResultParser, ClusterSettings clusterSettings, CacheType cacheType) {
        if (threshold.compareTo(TimeValue.ZERO) < 0) {
            throw new IllegalArgumentException("Threshold for TookTimePolicy must be >= 0ms but was " + threshold.getStringRep());
        }
        this.threshold = threshold;
        this.cachedResultParser = cachedResultParser;
        clusterSettings.addSettingsUpdateConsumer(TieredSpilloverCacheSettings.TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAP.get(cacheType), this::setThreshold);
    }

    private void setThreshold(TimeValue threshold) {
        this.threshold = threshold;
    }

    @Override
    public boolean test(V data) {
        long tookTimeNanos;
        try {
            tookTimeNanos = this.cachedResultParser.apply(data).getTookTimeNanos();
        }
        catch (Exception e) {
            return false;
        }
        TimeValue tookTime = TimeValue.timeValueNanos((long)tookTimeNanos);
        return tookTime.compareTo(this.threshold) >= 0;
    }
}

