/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.search.SearchService;
import org.opensearch.tasks.CancellableTask;

@PublicApi(since="2.18.0")
public class QueryGroupTask
extends CancellableTask {
    private static final Logger logger = LogManager.getLogger(QueryGroupTask.class);
    public static final String QUERY_GROUP_ID_HEADER = "queryGroupId";
    public static final Supplier<String> DEFAULT_QUERY_GROUP_ID_SUPPLIER = () -> "DEFAULT_QUERY_GROUP";
    private final LongSupplier nanoTimeSupplier;
    private String queryGroupId;

    public QueryGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        this(id, type, action, description, parentTaskId, headers, SearchService.NO_TIMEOUT, System::nanoTime);
    }

    public QueryGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval) {
        this(id, type, action, description, parentTaskId, headers, cancelAfterTimeInterval, System::nanoTime);
    }

    public QueryGroupTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, TimeValue cancelAfterTimeInterval, LongSupplier nanoTimeSupplier) {
        super(id, type, action, description, parentTaskId, headers, cancelAfterTimeInterval);
        this.nanoTimeSupplier = nanoTimeSupplier;
    }

    public final String getQueryGroupId() {
        if (this.queryGroupId == null) {
            logger.warn("QueryGroup _id can't be null, It should be set before accessing it. This is abnormal behaviour ");
        }
        return this.queryGroupId;
    }

    public final void setQueryGroupId(ThreadContext threadContext) {
        this.queryGroupId = threadContext != null && threadContext.getHeader(QUERY_GROUP_ID_HEADER) != null ? threadContext.getHeader(QUERY_GROUP_ID_HEADER) : DEFAULT_QUERY_GROUP_ID_SUPPLIER.get();
    }

    public long getElapsedTime() {
        return this.nanoTimeSupplier.getAsLong() - this.getStartTimeNanos();
    }

    @Override
    public boolean shouldCancelChildrenOnCancellation() {
        return false;
    }
}

