/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.wlm.ResourceType;

@ExperimentalApi
public class MutableQueryGroupFragment
extends AbstractDiffable<MutableQueryGroupFragment> {
    public static final String RESILIENCY_MODE_STRING = "resiliency_mode";
    public static final String RESOURCE_LIMITS_STRING = "resource_limits";
    private ResiliencyMode resiliencyMode;
    private Map<ResourceType, Double> resourceLimits;
    public static final List<String> acceptedFieldNames = List.of("resiliency_mode", "resource_limits");
    private final Map<String, Function<XContentBuilder, Void>> toXContentMap = Map.of("resiliency_mode", builder -> {
        try {
            builder.field(RESILIENCY_MODE_STRING, this.resiliencyMode.getName());
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("writing error encountered for the field resiliency_mode");
        }
    }, "resource_limits", builder -> {
        try {
            builder.startObject(RESOURCE_LIMITS_STRING);
            for (ResourceType resourceType : ResourceType.values()) {
                if (!this.resourceLimits.containsKey((Object)resourceType)) continue;
                builder.field(resourceType.getName(), this.resourceLimits.get((Object)resourceType));
            }
            builder.endObject();
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("writing error encountered for the field resource_limits");
        }
    });

    public MutableQueryGroupFragment() {
    }

    public MutableQueryGroupFragment(ResiliencyMode resiliencyMode, Map<ResourceType, Double> resourceLimits) {
        MutableQueryGroupFragment.validateResourceLimits(resourceLimits);
        this.resiliencyMode = resiliencyMode;
        this.resourceLimits = resourceLimits;
    }

    public MutableQueryGroupFragment(StreamInput in) throws IOException {
        this.resourceLimits = in.readBoolean() ? in.readMap(i -> ResourceType.fromName(i.readString()), StreamInput::readDouble) : new HashMap<ResourceType, Double>();
        String updatedResiliencyMode = in.readOptionalString();
        this.resiliencyMode = updatedResiliencyMode == null ? null : ResiliencyMode.fromName(updatedResiliencyMode);
    }

    public static boolean shouldParse(String field) {
        return FieldParserFactory.fieldParserFor(field).isPresent();
    }

    public void parseField(XContentParser parser, String field) {
        FieldParserFactory.fieldParserFor(field).ifPresent(fieldParser -> {
            try {
                Object value = fieldParser.parseField(parser);
                if (field.equals(RESILIENCY_MODE_STRING)) {
                    this.setResiliencyMode((ResiliencyMode)((Object)((Object)value)));
                } else if (field.equals(RESOURCE_LIMITS_STRING)) {
                    this.setResourceLimits((Map)value);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("parsing error encountered for the field " + field);
            }
        });
    }

    public void writeField(XContentBuilder builder, String field) {
        this.toXContentMap.get(field).apply(builder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.resourceLimits == null || this.resourceLimits.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.resourceLimits, ResourceType::writeTo, StreamOutput::writeDouble);
        }
        out.writeOptionalString(this.resiliencyMode == null ? null : this.resiliencyMode.getName());
    }

    public static void validateResourceLimits(Map<ResourceType, Double> resourceLimits) {
        if (resourceLimits == null) {
            return;
        }
        for (Map.Entry<ResourceType, Double> resource : resourceLimits.entrySet()) {
            Double threshold = resource.getValue();
            Objects.requireNonNull(resource.getKey(), "resourceName can't be null");
            Objects.requireNonNull(threshold, "resource limit threshold for" + resource.getKey().getName() + " : can't be null");
            if (Double.compare(threshold, 0.0) > 0 && Double.compare(threshold, 1.0) <= 0) continue;
            throw new IllegalArgumentException("resource value should be greater than 0 and less or equal to 1.0");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableQueryGroupFragment that = (MutableQueryGroupFragment)o;
        return Objects.equals((Object)this.resiliencyMode, (Object)that.resiliencyMode) && Objects.equals(this.resourceLimits, that.resourceLimits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resiliencyMode, this.resourceLimits});
    }

    public ResiliencyMode getResiliencyMode() {
        return this.resiliencyMode;
    }

    public Map<ResourceType, Double> getResourceLimits() {
        return this.resourceLimits;
    }

    public void setResiliencyMode(ResiliencyMode resiliencyMode) {
        this.resiliencyMode = resiliencyMode;
    }

    public void setResourceLimits(Map<ResourceType, Double> resourceLimits) {
        MutableQueryGroupFragment.validateResourceLimits(resourceLimits);
        this.resourceLimits = resourceLimits;
    }

    @ExperimentalApi
    public static enum ResiliencyMode {
        SOFT("soft"),
        ENFORCED("enforced"),
        MONITOR("monitor");

        private final String name;

        private ResiliencyMode(String mode) {
            this.name = mode;
        }

        public String getName() {
            return this.name;
        }

        public static ResiliencyMode fromName(String s) {
            for (ResiliencyMode mode : ResiliencyMode.values()) {
                if (!mode.getName().equalsIgnoreCase(s)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Invalid value for QueryGroupMode: " + s);
        }
    }

    static class FieldParserFactory {
        FieldParserFactory() {
        }

        static Optional<FieldParser<?>> fieldParserFor(String fieldName) {
            if (fieldName.equals(MutableQueryGroupFragment.RESOURCE_LIMITS_STRING)) {
                return Optional.of(new ResourceLimitsParser());
            }
            if (fieldName.equals(MutableQueryGroupFragment.RESILIENCY_MODE_STRING)) {
                return Optional.of(new ResiliencyModeParser());
            }
            return Optional.empty();
        }
    }

    static interface FieldParser<T> {
        public T parseField(XContentParser var1) throws IOException;
    }

    static class ResourceLimitsParser
    implements FieldParser<Map<ResourceType, Double>> {
        ResourceLimitsParser() {
        }

        @Override
        public Map<ResourceType, Double> parseField(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String fieldName = "";
            HashMap<ResourceType, Double> resourceLimits = new HashMap<ResourceType, Double>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                resourceLimits.put(ResourceType.fromName(fieldName), parser.doubleValue());
            }
            return resourceLimits;
        }
    }

    static class ResiliencyModeParser
    implements FieldParser<ResiliencyMode> {
        ResiliencyModeParser() {
        }

        @Override
        public ResiliencyMode parseField(XContentParser parser) throws IOException {
            return ResiliencyMode.fromName(parser.text());
        }
    }
}

