/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.InboundMessage;
import org.opensearch.transport.NativeMessageHandler;
import org.opensearch.transport.OutboundHandler;
import org.opensearch.transport.ProtocolMessageHandler;
import org.opensearch.transport.StatsTracker;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportHandshaker;
import org.opensearch.transport.TransportKeepAlive;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.TransportProtocol;

public class InboundHandler {
    private final ThreadPool threadPool;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;
    private volatile long slowLogThresholdMs = Long.MAX_VALUE;
    private final Map<TransportProtocol, ProtocolMessageHandler> protocolMessageHandlers;

    InboundHandler(String nodeName, Version version, String[] features, StatsTracker statsTracker, ThreadPool threadPool, BigArrays bigArrays, OutboundHandler outboundHandler, NamedWriteableRegistry namedWriteableRegistry, TransportHandshaker handshaker, TransportKeepAlive keepAlive, Transport.RequestHandlers requestHandlers, Transport.ResponseHandlers responseHandlers, Tracer tracer) {
        this.threadPool = threadPool;
        this.protocolMessageHandlers = Map.of(TransportProtocol.NATIVE, new NativeMessageHandler(nodeName, version, features, statsTracker, threadPool, bigArrays, outboundHandler, namedWriteableRegistry, handshaker, requestHandlers, responseHandlers, tracer, keepAlive));
    }

    void setMessageListener(TransportMessageListener listener) {
        this.protocolMessageHandlers.values().forEach(handler -> handler.setMessageListener(listener));
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.slowLogThresholdMs = slowLogThreshold.getMillis();
    }

    void inboundMessage(TcpChannel channel, InboundMessage message) throws Exception {
        long startTime = this.threadPool.relativeTimeInMillis();
        channel.getChannelStats().markAccessed(startTime);
        this.messageReceivedFromPipeline(channel, message, startTime);
    }

    private void messageReceivedFromPipeline(TcpChannel channel, InboundMessage message, long startTime) throws IOException {
        ProtocolMessageHandler protocolMessageHandler = this.protocolMessageHandlers.get((Object)message.getTransportProtocol());
        if (protocolMessageHandler == null) {
            throw new IllegalStateException("No protocol message handler found for protocol: " + message.getTransportProtocol());
        }
        protocolMessageHandler.messageReceived(channel, message, startTime, this.slowLogThresholdMs, this.messageListener);
    }
}

