/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree;

import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;

@ExperimentalApi
public class StarTreeQueryContext {
    private final CompositeIndexFieldInfo starTree;
    private final Map<String, Long> queryMap;
    private final FixedBitSet[] starTreeValues;

    public StarTreeQueryContext(CompositeIndexFieldInfo starTree, Map<String, Long> queryMap, int numSegmentsCache) {
        this.starTree = starTree;
        this.queryMap = queryMap;
        this.starTreeValues = numSegmentsCache > -1 ? new FixedBitSet[numSegmentsCache] : null;
    }

    public CompositeIndexFieldInfo getStarTree() {
        return this.starTree;
    }

    public Map<String, Long> getQueryMap() {
        return this.queryMap;
    }

    public FixedBitSet[] getStarTreeValues() {
        return this.starTreeValues;
    }

    public FixedBitSet getStarTreeValues(LeafReaderContext ctx) {
        if (this.starTreeValues != null) {
            return this.starTreeValues[ctx.ord];
        }
        return null;
    }

    public void setStarTreeValues(LeafReaderContext ctx, FixedBitSet values) {
        if (this.starTreeValues != null) {
            this.starTreeValues[ctx.ord] = values;
        }
    }
}

