/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.common.util.LongArray;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeQueryHelper;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

class AvgAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource.Numeric valuesSource;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DocValueFormat format;

    AvgAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.counts = bigArrays.newLongArray(1L, true);
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context);
        if (supportedStarTree != null) {
            return this.getStarTreeLeafCollector(ctx, sub, supportedStarTree);
        }
        return this.getDefaultLeafCollector(ctx, sub);
    }

    private LeafBucketCollector getDefaultLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                AvgAggregator.this.counts = bigArrays.grow(AvgAggregator.this.counts, bucket + 1L);
                AvgAggregator.this.sums = bigArrays.grow(AvgAggregator.this.sums, bucket + 1L);
                AvgAggregator.this.compensations = bigArrays.grow(AvgAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    AvgAggregator.this.counts.increment(bucket, valueCount);
                    double sum = AvgAggregator.this.sums.get(bucket);
                    double compensation = AvgAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                    }
                    AvgAggregator.this.sums.set(bucket, kahanSummation.value());
                    AvgAggregator.this.compensations.set(bucket, kahanSummation.delta());
                }
            }
        };
    }

    public LeafBucketCollector getStarTreeLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub, CompositeIndexFieldInfo starTree) throws IOException {
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        assert (starTreeValues != null);
        String fieldName = ((ValuesSource.Numeric.FieldData)this.valuesSource).getIndexFieldName();
        String sumMetricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), fieldName, MetricStat.SUM.getTypeName());
        String countMetricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), fieldName, MetricStat.VALUE_COUNT.getTypeName());
        CompensatedSum kahanSummation = new CompensatedSum(this.sums.get(0L), 0.0);
        SortedNumericStarTreeValuesIterator sumValuesIterator = (SortedNumericStarTreeValuesIterator)starTreeValues.getMetricValuesIterator(sumMetricName);
        SortedNumericStarTreeValuesIterator countValueIterator = (SortedNumericStarTreeValuesIterator)starTreeValues.getMetricValuesIterator(countMetricName);
        FixedBitSet matchedDocIds = StarTreeQueryHelper.getStarTreeFilteredValues(this.context, ctx, starTreeValues);
        assert (matchedDocIds != null);
        int numBits = matchedDocIds.length();
        if (numBits > 0) {
            int bit = matchedDocIds.nextSetBit(0);
            while (bit != Integer.MAX_VALUE) {
                if (sumValuesIterator.advanceExact(bit) && countValueIterator.advanceExact(bit)) {
                    for (int i = 0; i < sumValuesIterator.entryValueCount(); ++i) {
                        kahanSummation.add(NumericUtils.sortableLongToDouble((long)sumValuesIterator.nextValue()));
                        this.counts.increment(0L, countValueIterator.nextValue());
                    }
                }
                bit = bit + 1 < numBits ? matchedDocIds.nextSetBit(bit + 1) : Integer.MAX_VALUE;
            }
        }
        this.sums.set(0L, kahanSummation.value());
        return new LeafBucketCollectorBase(sub, this.valuesSource.doubleValues(ctx)){

            @Override
            public void collect(int doc, long bucket) {
                throw new CollectionTerminatedException();
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.sums, this.compensations});
    }
}

