/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.Nullable;
import org.opensearch.rest.MethodHandlers;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

final class RestMethodHandlers
implements MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, RestHandler> methodHandlers;

    RestMethodHandlers(String path, RestHandler handler, RestRequest.Method ... methods) {
        this.path = path;
        this.methodHandlers = new HashMap<RestRequest.Method, RestHandler>(methods.length);
        for (RestRequest.Method method : methods) {
            this.methodHandlers.put(method, handler);
        }
    }

    public RestMethodHandlers addMethods(RestHandler handler, RestRequest.Method ... methods) {
        for (RestRequest.Method method : methods) {
            RestHandler existing = this.methodHandlers.putIfAbsent(method, handler);
            if (existing == null) continue;
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + method);
        }
        return this;
    }

    @Nullable
    public RestHandler getHandler(RestRequest.Method method) {
        return this.methodHandlers.get((Object)method);
    }

    @Override
    public Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

