/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.DimensionFactory;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeFieldConfiguration;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeIndexSettings;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.mapper.CompositeMappedFieldType;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.DocumentMapperParser;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SearchLookup;

@ExperimentalApi
public class StarTreeMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "star_tree";
    public static final String CONFIG = "config";
    public static final String MAX_LEAF_DOCS = "max_leaf_docs";
    public static final String SKIP_STAR_NODE_IN_DIMS = "skip_star_node_creation_for_dimensions";
    public static final String ORDERED_DIMENSIONS = "ordered_dimensions";
    public static final String DATE_DIMENSION = "date_dimension";
    public static final String METRICS = "metrics";
    public static final String STATS = "stats";
    private final StarTreeField starTreeField;
    private final ObjectMapper.Builder objBuilder;

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.objBuilder).init(this);
    }

    private static StarTreeMapper toType(FieldMapper in) {
        return (StarTreeMapper)in;
    }

    protected StarTreeMapper(String simpleName, StarTreeFieldType type, Builder builder, ObjectMapper.Builder objbuilder) {
        super(simpleName, type, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.starTreeField = builder.config.get();
        this.objBuilder = objbuilder;
    }

    @Override
    public StarTreeFieldType fieldType() {
        return (StarTreeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void parseCreateField(ParseContext context) {
        throw new MapperParsingException(String.format(Locale.ROOT, "Field [%s] is a star tree field and cannot be added inside a document. Use the index API request parameters.", this.name()));
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private ObjectMapper.Builder objbuilder;
        private final ParametrizedFieldMapper.Parameter<StarTreeField> config = new ParametrizedFieldMapper.Parameter<StarTreeField>("config", false, () -> null, (name, context, nodeObj) -> {
            if (nodeObj instanceof Map) {
                Map paramMap = (Map)nodeObj;
                int maxLeafDocs = XContentMapValues.nodeIntegerValue(paramMap.get(StarTreeMapper.MAX_LEAF_DOCS), StarTreeIndexSettings.STAR_TREE_DEFAULT_MAX_LEAF_DOCS.get(context.getSettings()));
                if (maxLeafDocs < 1) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s [%s] must be greater than 0", StarTreeMapper.MAX_LEAF_DOCS, maxLeafDocs));
                }
                paramMap.remove(StarTreeMapper.MAX_LEAF_DOCS);
                LinkedHashSet<String> skipStarInDims = new LinkedHashSet<String>(List.of(XContentMapValues.nodeStringArrayValue(paramMap.getOrDefault(StarTreeMapper.SKIP_STAR_NODE_IN_DIMS, new ArrayList()))));
                paramMap.remove(StarTreeMapper.SKIP_STAR_NODE_IN_DIMS);
                StarTreeFieldConfiguration.StarTreeBuildMode buildMode = StarTreeFieldConfiguration.StarTreeBuildMode.OFF_HEAP;
                List<Dimension> dimensions = this.buildDimensions((String)name, paramMap, (Mapper.TypeParser.ParserContext)context);
                paramMap.remove(StarTreeMapper.DATE_DIMENSION);
                paramMap.remove(StarTreeMapper.ORDERED_DIMENSIONS);
                List<Metric> metrics = this.buildMetrics((String)name, paramMap, (Mapper.TypeParser.ParserContext)context);
                paramMap.remove(StarTreeMapper.METRICS);
                paramMap.remove("name");
                for (String dim : skipStarInDims) {
                    if (!dimensions.stream().filter(d -> d.getField().equals(dim)).findAny().isEmpty()) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] in skip_star_node_creation_for_dimensions should be part of ordered_dimensions", dim));
                }
                StarTreeFieldConfiguration spec = new StarTreeFieldConfiguration(maxLeafDocs, skipStarInDims, buildMode);
                DocumentMapperParser.checkNoRemainingFields(paramMap, context.indexVersionCreated(), "Star tree mapping definition has unsupported parameters: ");
                return new StarTreeField(this.name, dimensions, metrics, spec);
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "unable to parse config for star tree field [%s]", this.name));
        }, m -> StarTreeMapper.toType((FieldMapper)m).starTreeField);

        private List<Dimension> buildDimensions(String fieldName, Map<String, Object> map, Mapper.TypeParser.ParserContext context) {
            Object dims;
            LinkedList<Dimension> dimensions = new LinkedList<Dimension>();
            DateDimension dateDim = this.buildDateDimension(fieldName, map, context);
            if (dateDim != null) {
                dimensions.add(dateDim);
            }
            if ((dims = XContentMapValues.extractValue(StarTreeMapper.ORDERED_DIMENSIONS, map)) == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "ordered_dimensions is required for star tree field [%s]", fieldName));
            }
            if (dims instanceof List) {
                List orderedDimensionsList = (List)dims;
                if (orderedDimensionsList.size() + dimensions.size() > context.getSettings().getAsInt(StarTreeIndexSettings.STAR_TREE_MAX_DIMENSIONS_SETTING.getKey(), StarTreeIndexSettings.STAR_TREE_MAX_DIMENSIONS_DEFAULT)) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "ordered_dimensions cannot have more than %s dimensions for star tree field [%s]", context.getSettings().getAsInt(StarTreeIndexSettings.STAR_TREE_MAX_DIMENSIONS_SETTING.getKey(), StarTreeIndexSettings.STAR_TREE_MAX_DIMENSIONS_DEFAULT), fieldName));
                }
                if (dimensions.size() + orderedDimensionsList.size() < 2) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Atleast two dimensions are required to build star tree index field [%s]", fieldName));
                }
                HashSet<String> dimensionFieldNames = new HashSet<String>();
                for (Object dim : orderedDimensionsList) {
                    Dimension dimension = this.getDimension(fieldName, dim, context);
                    if (!dimensionFieldNames.add(dimension.getField())) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Duplicate dimension [%s] present as part star tree index field [%s]", dimension.getField(), fieldName));
                    }
                    dimensions.add(dimension);
                }
            } else {
                throw new MapperParsingException(String.format(Locale.ROOT, "unable to parse ordered_dimensions for star tree field [%s]", fieldName));
            }
            return dimensions;
        }

        private DateDimension buildDateDimension(String fieldName, Map<String, Object> map, Mapper.TypeParser.ParserContext context) {
            Object dims = XContentMapValues.extractValue(StarTreeMapper.DATE_DIMENSION, map);
            if (dims == null) {
                return null;
            }
            return this.getDateDimension(fieldName, dims, context);
        }

        private DateDimension getDateDimension(String fieldName, Object dimensionMapping, Mapper.TypeParser.ParserContext context) {
            Map dimensionMap = (Map)dimensionMapping;
            String name = (String)XContentMapValues.extractValue("name", dimensionMap);
            dimensionMap.remove("name");
            if (this.objbuilder == null || this.objbuilder.mappersBuilders == null) {
                String type = (String)XContentMapValues.extractValue("type", dimensionMap);
                dimensionMap.remove("type");
                if (type == null || !type.equals("date")) {
                    throw new MapperParsingException(String.format(Locale.ROOT, "unable to parse date dimension for star tree field [%s]", fieldName));
                }
                return (DateDimension)DimensionFactory.parseAndCreateDimension(name, type, (Map<String, Object>)dimensionMap, context);
            }
            Optional<Mapper.Builder> dimBuilder = this.findMapperBuilderByName(name, this.objbuilder.mappersBuilders);
            if (dimBuilder.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "unknown date dimension field [%s]", name));
            }
            if (!(dimBuilder.get() instanceof DateFieldMapper.Builder)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "date_dimension [%s] should be of type date for star tree field [%s]", name, fieldName));
            }
            DateDimension dimension = (DateDimension)DimensionFactory.parseAndCreateDimension(name, dimBuilder.get(), (Map<String, Object>)dimensionMap, context);
            DocumentMapperParser.checkNoRemainingFields(dimensionMap, context.indexVersionCreated(), "Star tree mapping definition has unsupported parameters: ");
            return dimension;
        }

        private Dimension getDimension(String fieldName, Object dimensionMapping, Mapper.TypeParser.ParserContext context) {
            Map dimensionMap = (Map)dimensionMapping;
            String name = (String)XContentMapValues.extractValue("name", dimensionMap);
            dimensionMap.remove("name");
            if (this.objbuilder == null || this.objbuilder.mappersBuilders == null) {
                String type = (String)XContentMapValues.extractValue("type", dimensionMap);
                dimensionMap.remove("type");
                if (type == null) {
                    throw new MapperParsingException(String.format(Locale.ROOT, "unable to parse ordered_dimensions for star tree field [%s]", fieldName));
                }
                return DimensionFactory.parseAndCreateDimension(name, type, (Map<String, Object>)dimensionMap, context);
            }
            Optional<Mapper.Builder> dimBuilder = this.findMapperBuilderByName(name, this.objbuilder.mappersBuilders);
            if (dimBuilder.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "unknown dimension field [%s]", name));
            }
            if (!Builder.isBuilderAllowedForDimension(dimBuilder.get())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "unsupported field type associated with dimension [%s] as part of star tree field [%s]", name, fieldName));
            }
            Dimension dimension = DimensionFactory.parseAndCreateDimension(name, dimBuilder.get(), (Map<String, Object>)dimensionMap, context);
            DocumentMapperParser.checkNoRemainingFields(dimensionMap, context.indexVersionCreated(), "Star tree mapping definition has unsupported parameters: ");
            return dimension;
        }

        private List<Metric> buildMetrics(String fieldName, Map<String, Object> map, Mapper.TypeParser.ParserContext context) {
            LinkedList<Metric> metrics = new LinkedList<Metric>();
            Object metricsFromInput = XContentMapValues.extractValue(StarTreeMapper.METRICS, map);
            if (metricsFromInput == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "metrics section is required for star tree field [%s]", fieldName));
            }
            if (metricsFromInput instanceof List) {
                List metricsList = (List)metricsFromInput;
                HashSet metricFieldNames = new HashSet();
                for (Object metric : metricsList) {
                    Map metricMap = (Map)metric;
                    String name = (String)XContentMapValues.extractValue("name", metricMap);
                    if (name.equals("_doc_count")) continue;
                    metricMap.remove("name");
                    if (this.objbuilder == null || this.objbuilder.mappersBuilders == null) {
                        Metric metricFromParser = this.getMetric(name, metricMap, context);
                        if (!metricFieldNames.add(metricFromParser.getField())) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Duplicate metrics [%s] present as part star tree index field [%s]", metricFromParser.getField(), fieldName));
                        }
                        metrics.add(metricFromParser);
                        continue;
                    }
                    Optional<Mapper.Builder> meticBuilder = this.findMapperBuilderByName(name, this.objbuilder.mappersBuilders);
                    if (meticBuilder.isEmpty()) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "unknown metric field [%s]", name));
                    }
                    if (!Builder.isBuilderAllowedForMetric(meticBuilder.get())) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "non-numeric field type is associated with star tree metric [%s]", this.name));
                    }
                    Metric metricFromParser = this.getMetric(name, metricMap, context);
                    if (!metricFieldNames.add(metricFromParser.getField())) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "Duplicate metrics [%s] present as part star tree index field [%s]", metricFromParser.getField(), fieldName));
                    }
                    metrics.add(metricFromParser);
                    DocumentMapperParser.checkNoRemainingFields(metricMap, context.indexVersionCreated(), "Star tree mapping definition has unsupported parameters: ");
                }
            } else {
                throw new MapperParsingException(String.format(Locale.ROOT, "unable to parse metrics for star tree field [%s]", this.name));
            }
            int numBaseMetrics = 0;
            for (Metric metric : metrics) {
                numBaseMetrics += metric.getBaseMetrics().size();
            }
            if (numBaseMetrics > context.getSettings().getAsInt(StarTreeIndexSettings.STAR_TREE_MAX_BASE_METRICS_SETTING.getKey(), StarTreeIndexSettings.STAR_TREE_MAX_BASE_METRICS_DEFAULT)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "There cannot be more than [%s] base metrics for star tree field [%s]", context.getSettings().getAsInt(StarTreeIndexSettings.STAR_TREE_MAX_BASE_METRICS_SETTING.getKey(), StarTreeIndexSettings.STAR_TREE_MAX_BASE_METRICS_DEFAULT), fieldName));
            }
            Metric docCountMetric = new Metric("_doc_count", List.of(MetricStat.DOC_COUNT));
            metrics.add(docCountMetric);
            return metrics;
        }

        private Metric getMetric(String name, Map<String, Object> metric, Mapper.TypeParser.ParserContext context) {
            List metricStrings = XContentMapValues.extractRawValues(StarTreeMapper.STATS, metric).stream().map(Object::toString).collect(Collectors.toList());
            metric.remove(StarTreeMapper.STATS);
            if (metricStrings.isEmpty()) {
                metricStrings = new ArrayList((Collection)StarTreeIndexSettings.DEFAULT_METRICS_LIST.get(context.getSettings()));
            }
            LinkedHashSet<MetricStat> metricSet = new LinkedHashSet<MetricStat>();
            for (String metricString : metricStrings) {
                MetricStat metricStat = MetricStat.fromTypeName(metricString);
                metricSet.add(metricStat);
                this.addBaseMetrics(metricStat, metricSet);
            }
            this.addEligibleDerivedMetrics(metricSet);
            ArrayList<MetricStat> metricTypes = new ArrayList<MetricStat>(metricSet);
            return new Metric(name, metricTypes);
        }

        private void addBaseMetrics(MetricStat metricStat, Set<MetricStat> metricSet) {
            if (metricStat.isDerivedMetric()) {
                LinkedList<MetricStat> metricQueue = new LinkedList<MetricStat>(metricStat.getBaseMetrics());
                while (!metricQueue.isEmpty()) {
                    MetricStat metric = (MetricStat)((Object)metricQueue.poll());
                    if (metric.isDerivedMetric() && !metricSet.contains((Object)metric)) {
                        metricQueue.addAll(metric.getBaseMetrics());
                    }
                    metricSet.add(metric);
                }
            }
        }

        private void addEligibleDerivedMetrics(Set<MetricStat> metricStats) {
            for (MetricStat metric : MetricStat.values()) {
                List<MetricStat> sourceMetrics;
                if (!metric.isDerivedMetric() || metricStats.contains((Object)metric) || !metricStats.containsAll(sourceMetrics = metric.getBaseMetrics())) continue;
                metricStats.add(metric);
            }
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return List.of(this.config);
        }

        private static boolean isBuilderAllowedForDimension(Mapper.Builder builder) {
            return builder.getSupportedDataCubeDimensionType().isPresent();
        }

        private static boolean isBuilderAllowedForMetric(Mapper.Builder builder) {
            return builder.isDataCubeMetricSupported();
        }

        private Optional<Mapper.Builder> findMapperBuilderByName(String field, List<Mapper.Builder> mappersBuilders) {
            return mappersBuilders.stream().filter(builder -> builder.name().equals(field)).findFirst();
        }

        public Builder(String name2, ObjectMapper.Builder objBuilder) {
            super(name2);
            this.objbuilder = objBuilder;
        }

        @Override
        public ParametrizedFieldMapper build(Mapper.BuilderContext context) {
            StarTreeFieldType type = new StarTreeFieldType(this.name, this.config.get());
            return new StarTreeMapper(this.name, type, this, this.objbuilder);
        }
    }

    @ExperimentalApi
    public static final class StarTreeFieldType
    extends CompositeDataCubeFieldType {
        private final StarTreeFieldConfiguration starTreeConfig;

        public StarTreeFieldType(String name, StarTreeField starTreeField) {
            super(name, starTreeField.getDimensionsOrder(), starTreeField.getMetrics(), CompositeMappedFieldType.CompositeFieldType.STAR_TREE);
            this.starTreeConfig = starTreeField.getStarTreeConfig();
        }

        public StarTreeFieldConfiguration getStarTreeConfig() {
            return this.starTreeConfig;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for star tree field [" + this.name() + "].");
        }

        @Override
        public String typeName() {
            return StarTreeMapper.CONTENT_TYPE;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot perform terms query on star tree field [" + this.name() + "].");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext context) throws MapperParsingException {
            Builder builder = new Builder(name, null);
            builder.parse(name, context, node);
            return builder;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext context, ObjectMapper.Builder objBuilder) throws MapperParsingException {
            Builder builder = new Builder(name, objBuilder);
            builder.parse(name, context, node);
            return builder;
        }
    }
}

