/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Iterators;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.xcontent.JsonToStringXContentParser;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.DynamicKeyFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public final class FlatObjectFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flat_object";
    public static final TypeParser PARSER = new TypeParser((n, c) -> new Builder((String)n));
    private final ValueFieldMapper valueFieldMapper;
    private final ValueAndPathFieldMapper valueAndPathFieldMapper;

    @Override
    public MappedFieldType keyedFieldType(String key) {
        return new FlatObjectFieldType(this.name() + "." + key, this.name(), (KeywordFieldMapper.KeywordFieldType)this.valueFieldMapper.fieldType(), (KeywordFieldMapper.KeywordFieldType)this.valueAndPathFieldMapper.fieldType());
    }

    FlatObjectFieldMapper(String simpleName, FieldType fieldType, FlatObjectFieldType mappedFieldType, ValueFieldMapper valueFieldMapper, ValueAndPathFieldMapper valueAndPathFieldMapper, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, fieldType, mappedFieldType, copyTo);
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.fieldType = fieldType;
        this.valueFieldMapper = valueFieldMapper;
        this.valueAndPathFieldMapper = valueAndPathFieldMapper;
        this.mappedFieldType = mappedFieldType;
    }

    @Override
    protected FlatObjectFieldMapper clone() {
        return (FlatObjectFieldMapper)super.clone();
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    @Override
    public FlatObjectFieldType fieldType() {
        return (FlatObjectFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String fieldName = null;
        if (context.externalValueSet()) {
            String value = context.externalValue().toString();
            this.parseValueAddFields(context, value, this.fieldType().name());
        } else {
            XContentParser ctxParser = context.parser();
            if (ctxParser.currentToken() != XContentParser.Token.VALUE_NULL) {
                XContentParser.Token currentToken;
                if (ctxParser.currentToken() != XContentParser.Token.START_OBJECT) {
                    throw new ParsingException(ctxParser.getTokenLocation(), "[" + this.name() + "] unexpected token [" + ctxParser.currentToken() + "] in flat_object field value", new Object[0]);
                }
                JsonToStringXContentParser jsonToStringParser = new JsonToStringXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, ctxParser, this.fieldType().name());
                XContentParser parser = jsonToStringParser.parseObject();
                while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    switch (currentToken) {
                        case FIELD_NAME: {
                            fieldName = parser.currentName();
                            break;
                        }
                        case VALUE_STRING: {
                            String value = parser.textOrNull();
                            this.parseValueAddFields(context, value, fieldName);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        if (this.valueFieldMapper != null) {
            subIterators.add(this.valueFieldMapper);
        }
        if (this.valueAndPathFieldMapper != null) {
            subIterators.add(this.valueAndPathFieldMapper);
        }
        if (subIterators.size() == 0) {
            return super.iterator();
        }
        Iterator concat = Iterators.concat((Iterator[])new Iterator[]{super.iterator(), subIterators.iterator()});
        return concat;
    }

    private void parseValueAddFields(ParseContext context, String value, String fieldName) throws IOException {
        assert (this.valueFieldMapper != null);
        assert (this.valueAndPathFieldMapper != null);
        NamedAnalyzer normalizer = this.fieldType().normalizer();
        if (normalizer != null) {
            value = FlatObjectFieldMapper.normalizeValue(normalizer, this.name(), value);
        }
        String[] valueTypeList = fieldName.split("\\._");
        String valueType = "._" + valueTypeList[valueTypeList.length - 1];
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            BytesRef binaryValue = new BytesRef((CharSequence)(this.fieldType().name() + "." + value));
            if (!this.fieldType().hasDocValues()) {
                this.createFieldNamesField(context);
            }
            if (fieldName.equals(this.fieldType().name())) {
                FlatObjectField field = new FlatObjectField(this.fieldType().name(), binaryValue, this.fieldType);
                context.doc().add((IndexableField)field);
            } else if (valueType.equals("._value")) {
                this.valueFieldMapper.addField(context, value);
            } else if (valueType.equals("._valueAndPath")) {
                this.valueAndPathFieldMapper.addField(context, value);
            }
            if (this.fieldType().hasDocValues()) {
                if (fieldName.equals(this.fieldType().name())) {
                    context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
                } else if (valueType.equals("._value")) {
                    context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name() + "._value", binaryValue));
                } else if (valueType.equals("._valueAndPath")) {
                    context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().name() + "._valueAndPath", binaryValue));
                }
            }
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) throws IOException {
        try (TokenStream ts = normalizer.tokenStream(field, value);){
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            if (!ts.incrementToken()) {
                throw new IllegalStateException(FlatObjectFieldMapper.errorMessage(normalizer, value));
            }
            String newValue = termAtt.toString();
            if (ts.incrementToken()) {
                throw new IllegalStateException(FlatObjectFieldMapper.errorMessage(normalizer, value));
            }
            ts.end();
            String string = newValue;
            return string;
        }
    }

    private static String errorMessage(NamedAnalyzer normalizer, String value) {
        return "The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + normalizer + " and input \"" + value + "\"";
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class FlatObjectFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final String mappedFieldTypeName;
        private final KeywordFieldMapper.KeywordFieldType valueFieldType;
        private final KeywordFieldMapper.KeywordFieldType valueAndPathFieldType;

        public FlatObjectFieldType(String name, String mappedFieldTypeName, boolean isSearchable, boolean hasDocValues, NamedAnalyzer analyzer, Map<String, String> meta) {
            super(name, isSearchable, false, hasDocValues, analyzer == null ? TextSearchInfo.SIMPLE_MATCH_ONLY : new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = mappedFieldTypeName;
            this.valueFieldType = FlatObjectFieldType.getKeywordFieldType(name, "._value", isSearchable, hasDocValues);
            this.valueAndPathFieldType = FlatObjectFieldType.getKeywordFieldType(name, "._valueAndPath", isSearchable, hasDocValues);
        }

        public FlatObjectFieldType(String name, String mappedFieldTypeName, KeywordFieldMapper.KeywordFieldType valueFieldType, KeywordFieldMapper.KeywordFieldType valueAndPathFieldType) {
            super(name, valueFieldType.isSearchable(), false, valueFieldType.hasDocValues(), new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.mappedFieldTypeName = mappedFieldTypeName;
            this.valueFieldType = valueFieldType;
            this.valueAndPathFieldType = valueAndPathFieldType;
        }

        static KeywordFieldMapper.KeywordFieldType getKeywordFieldType(final String fullName, String valueType, boolean isSearchable, boolean hasDocValue) {
            return new KeywordFieldMapper.KeywordFieldType(fullName + valueType, isSearchable, hasDocValue, Collections.emptyMap()){

                @Override
                protected String rewriteForDocValue(Object value) {
                    assert (value instanceof String);
                    return fullName + "." + value;
                }
            };
        }

        public KeywordFieldMapper.KeywordFieldType getValueFieldType() {
            return this.valueFieldType;
        }

        public KeywordFieldMapper.KeywordFieldType getValueAndPathFieldType() {
            return this.valueAndPathFieldType;
        }

        @Override
        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String flatObjectKeywordValue = value.toString();
                    if (flatObjectKeywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return flatObjectKeywordValue;
                    }
                    try {
                        return FlatObjectFieldMapper.normalizeValue(normalizer, this.name(), flatObjectKeywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            value = this.inputToString(value);
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        private KeywordFieldMapper.KeywordFieldType valueFieldType() {
            return this.mappedFieldTypeName == null ? this.valueFieldType : this.valueAndPathFieldType;
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String searchValueString = this.inputToString(value);
            String directSubFieldName = this.directSubfield();
            String rewriteSearchValue = this.rewriteValue(searchValueString);
            this.failIfNotIndexed();
            TermQuery query = new TermQuery(new Term(directSubFieldName, this.indexedValueForSearch(rewriteSearchValue)));
            if (this.boost() != 1.0f) {
                query = new BoostQuery((Query)query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            ArrayList<String> parsedValues = new ArrayList<String>(values.size());
            for (Object value : values) {
                parsedValues.add(this.rewriteValue(this.inputToString(value)));
            }
            return this.valueFieldType().termsQuery(parsedValues, context);
        }

        public String directSubfield() {
            if (this.mappedFieldTypeName == null) {
                return this.name() + "._value";
            }
            return this.mappedFieldTypeName + "._valueAndPath";
        }

        public String rewriteValue(String searchValueString) {
            if (!this.hasMappedFieldTyeNameInQueryFieldName(this.name())) {
                return searchValueString;
            }
            String rewriteSearchValue = this.name() + "=" + searchValueString;
            return rewriteSearchValue;
        }

        boolean hasMappedFieldTyeNameInQueryFieldName(String input) {
            String prefix = this.mappedFieldTypeName;
            if (prefix == null) {
                return false;
            }
            if (!input.startsWith(prefix)) {
                return false;
            }
            String rest = input.substring(prefix.length());
            return !rest.isEmpty();
        }

        private String inputToString(Object inputValue) {
            if (inputValue == null) {
                return null;
            }
            if (inputValue instanceof Integer) {
                String inputToString = Integer.toString((Integer)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Float) {
                String inputToString = Float.toString(((Float)inputValue).floatValue());
                return inputToString;
            }
            if (inputValue instanceof Boolean) {
                String inputToString = Boolean.toString((Boolean)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Short) {
                String inputToString = Short.toString((Short)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Long) {
                String inputToString = Long.toString((Long)inputValue);
                return inputToString;
            }
            if (inputValue instanceof Double) {
                String inputToString = Double.toString((Double)inputValue);
                return inputToString;
            }
            if (inputValue instanceof BytesRef) {
                String inputToString = ((BytesRef)inputValue).utf8ToString();
                return inputToString;
            }
            if (inputValue instanceof String) {
                String inputToString = (String)inputValue;
                return inputToString;
            }
            if (inputValue instanceof Version) {
                String inputToString = inputValue.toString();
                return inputToString;
            }
            return inputValue.toString();
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            return this.valueFieldType().prefixQuery(this.rewriteValue(value), method, caseInsensitive, context);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            return this.valueFieldType().regexpQuery(this.rewriteValue(value), syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            return this.valueFieldType().fuzzyQuery(this.rewriteValue(this.inputToString(value)), fuzziness, prefixLength, maxExpansions, transpositions, method, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            return this.valueFieldType().rangeQuery(this.rewriteValue(this.inputToString(lowerTerm)), this.rewriteValue(this.inputToString(upperTerm)), includeLower, includeUpper, context);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            String searchField;
            String searchKey;
            if (this.hasMappedFieldTyeNameInQueryFieldName(this.name())) {
                searchKey = this.mappedFieldTypeName;
                searchField = this.name();
            } else {
                if (this.hasDocValues()) {
                    return new FieldExistsQuery(this.name());
                }
                searchKey = "_field_names";
                searchField = this.name();
            }
            return new TermQuery(new Term(searchKey, this.indexedValueForSearch(searchField)));
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, QueryShardContext context) {
            return this.valueFieldType().wildcardQuery(this.rewriteValue(value), method, caseInsensitve, context);
        }
    }

    private static final class ValueFieldMapper
    extends FieldMapper {
        protected ValueFieldMapper(FieldType fieldType, KeywordFieldMapper.KeywordFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(ParseContext context, String value) {
            BytesRef binaryValue = new BytesRef((CharSequence)value);
            if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
                KeywordFieldMapper.KeywordField field = new KeywordFieldMapper.KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
                context.doc().add((IndexableField)field);
                if (!this.fieldType().hasDocValues()) {
                    this.createFieldNamesField(context);
                }
            }
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "value";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    private static final class ValueAndPathFieldMapper
    extends FieldMapper {
        protected ValueAndPathFieldMapper(FieldType fieldType, KeywordFieldMapper.KeywordFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(ParseContext context, String value) {
            BytesRef binaryValue = new BytesRef((CharSequence)value);
            if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
                KeywordFieldMapper.KeywordField field = new KeywordFieldMapper.KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
                context.doc().add((IndexableField)field);
                if (!this.fieldType().hasDocValues()) {
                    this.createFieldNamesField(context);
                }
            }
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "valueAndPath";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    public static class FlatObjectField
    extends Field {
        public FlatObjectField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        private ValueFieldMapper buildValueFieldMapper(FieldType fieldType, KeywordFieldMapper.KeywordFieldType valueFieldType) {
            FieldType vft = new FieldType((IndexableFieldType)fieldType);
            return new ValueFieldMapper(vft, valueFieldType);
        }

        private ValueAndPathFieldMapper buildValueAndPathFieldMapper(FieldType fieldType, KeywordFieldMapper.KeywordFieldType valueAndPathFieldType) {
            FieldType vft = new FieldType((IndexableFieldType)fieldType);
            return new ValueAndPathFieldMapper(vft, valueAndPathFieldType);
        }

        @Override
        public FlatObjectFieldMapper build(Mapper.BuilderContext context) {
            boolean isSearchable = true;
            boolean hasDocValue = true;
            KeywordFieldMapper.KeywordFieldType valueFieldType = FlatObjectFieldType.getKeywordFieldType(this.buildFullName(context), "._value", isSearchable, hasDocValue);
            KeywordFieldMapper.KeywordFieldType valueAndPathFieldType = FlatObjectFieldType.getKeywordFieldType(this.buildFullName(context), "._valueAndPath", isSearchable, hasDocValue);
            FlatObjectFieldType fft = new FlatObjectFieldType(this.buildFullName(context), null, valueFieldType, valueAndPathFieldType);
            return new FlatObjectFieldMapper(this.name, Defaults.FIELD_TYPE, fft, this.buildValueFieldMapper(Defaults.FIELD_TYPE, valueFieldType), this.buildValueAndPathFieldMapper(Defaults.FIELD_TYPE, valueAndPathFieldType), FieldMapper.CopyTo.empty(), this);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public TypeParser(BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(name, parserContext);
            return builder;
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

