/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.codec.composite.CompositeIndexReader;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.metrics.MetricAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeFilter;
import org.opensearch.search.startree.StarTreeQueryContext;

public class StarTreeQueryHelper {
    public static boolean isStarTreeSupported(SearchContext context) {
        return context.aggregations() != null && context.mapperService().isCompositeIndexPresent() && context.parsedPostFilter() == null;
    }

    public static StarTreeQueryContext getStarTreeQueryContext(SearchContext context, SearchSourceBuilder source) throws IOException {
        CompositeDataCubeFieldType compositeMappedFieldType = (CompositeDataCubeFieldType)context.mapperService().getCompositeFieldTypes().iterator().next();
        CompositeIndexFieldInfo starTree = new CompositeIndexFieldInfo(compositeMappedFieldType.name(), compositeMappedFieldType.getCompositeIndexType());
        for (AggregatorFactory aggregatorFactory : context.aggregations().factories().getFactories()) {
            MetricStat metricStat = StarTreeQueryHelper.validateStarTreeMetricSupport(compositeMappedFieldType, aggregatorFactory);
            if (metricStat != null) continue;
            return null;
        }
        boolean cacheStarTreeValues = context.aggregations().factories().getFactories().length > 1;
        int cacheSize = cacheStarTreeValues ? context.indexShard().segments(false).size() : -1;
        return StarTreeQueryHelper.tryCreateStarTreeQueryContext(starTree, compositeMappedFieldType, source.query(), cacheSize);
    }

    private static StarTreeQueryContext tryCreateStarTreeQueryContext(CompositeIndexFieldInfo compositeIndexFieldInfo, CompositeDataCubeFieldType compositeFieldType, QueryBuilder queryBuilder, int cacheStarTreeValuesSize) {
        Map<String, Long> queryMap;
        if (queryBuilder == null || queryBuilder instanceof MatchAllQueryBuilder) {
            queryMap = null;
        } else if (queryBuilder instanceof TermQueryBuilder) {
            if (compositeFieldType.getDimensions().stream().anyMatch(d -> d.getDocValuesType() != DocValuesType.SORTED_NUMERIC)) {
                return null;
            }
            List<String> supportedDimensions = compositeFieldType.getDimensions().stream().map(Dimension::getField).collect(Collectors.toList());
            queryMap = StarTreeQueryHelper.getStarTreePredicates(queryBuilder, supportedDimensions);
            if (queryMap == null) {
                return null;
            }
        } else {
            return null;
        }
        return new StarTreeQueryContext(compositeIndexFieldInfo, queryMap, cacheStarTreeValuesSize);
    }

    private static Map<String, Long> getStarTreePredicates(QueryBuilder queryBuilder, List<String> supportedDimensions) {
        TermQueryBuilder tq = (TermQueryBuilder)queryBuilder;
        String field = tq.fieldName();
        if (!supportedDimensions.contains(field)) {
            return null;
        }
        long inputQueryVal = Long.parseLong(tq.value().toString());
        HashMap<String, Long> predicateMap = new HashMap<String, Long>();
        predicateMap.put(field, inputQueryVal);
        return predicateMap;
    }

    private static MetricStat validateStarTreeMetricSupport(CompositeDataCubeFieldType compositeIndexFieldInfo, AggregatorFactory aggregatorFactory) {
        if (aggregatorFactory instanceof MetricAggregatorFactory && aggregatorFactory.getSubFactories().getFactories().length == 0) {
            Map<String, List> supportedMetrics = compositeIndexFieldInfo.getMetrics().stream().collect(Collectors.toMap(Metric::getField, Metric::getMetrics));
            MetricStat metricStat = ((MetricAggregatorFactory)aggregatorFactory).getMetricStat();
            String field = ((MetricAggregatorFactory)aggregatorFactory).getField();
            if (supportedMetrics.containsKey(field) && supportedMetrics.get(field).contains((Object)metricStat)) {
                return metricStat;
            }
        }
        return null;
    }

    public static CompositeIndexFieldInfo getSupportedStarTree(SearchContext context) {
        StarTreeQueryContext starTreeQueryContext = context.getStarTreeQueryContext();
        return starTreeQueryContext != null ? starTreeQueryContext.getStarTree() : null;
    }

    public static StarTreeValues getStarTreeValues(LeafReaderContext context, CompositeIndexFieldInfo starTree) throws IOException {
        SegmentReader reader = Lucene.segmentReader(context.reader());
        if (!(reader.getDocValuesReader() instanceof CompositeIndexReader)) {
            return null;
        }
        CompositeIndexReader starTreeDocValuesReader = (CompositeIndexReader)reader.getDocValuesReader();
        return (StarTreeValues)starTreeDocValuesReader.getCompositeIndexValues(starTree);
    }

    public static LeafBucketCollector getStarTreeLeafCollector(SearchContext context, ValuesSource.Numeric valuesSource, LeafReaderContext ctx, LeafBucketCollector sub, CompositeIndexFieldInfo starTree, String metric, Consumer<Long> valueConsumer, Runnable finalConsumer) throws IOException {
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        assert (starTreeValues != null);
        String fieldName = ((ValuesSource.Numeric.FieldData)valuesSource).getIndexFieldName();
        String metricName = StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(starTree.getField(), fieldName, metric);
        assert (starTreeValues != null);
        SortedNumericStarTreeValuesIterator valuesIterator = (SortedNumericStarTreeValuesIterator)starTreeValues.getMetricValuesIterator(metricName);
        FixedBitSet filteredValues = StarTreeQueryHelper.getStarTreeFilteredValues(context, ctx, starTreeValues);
        assert (filteredValues != null);
        int numBits = filteredValues.length();
        if (numBits > 0) {
            int bit = filteredValues.nextSetBit(0);
            while (bit != Integer.MAX_VALUE) {
                if (valuesIterator.advanceExact(bit)) {
                    int count = valuesIterator.entryValueCount();
                    for (int i = 0; i < count; ++i) {
                        long value = valuesIterator.nextValue();
                        valueConsumer.accept(value);
                    }
                }
                bit = bit + 1 < numBits ? filteredValues.nextSetBit(bit + 1) : Integer.MAX_VALUE;
            }
        }
        finalConsumer.run();
        return new LeafBucketCollectorBase(sub, valuesSource.doubleValues(ctx)){

            @Override
            public void collect(int doc, long bucket) {
                throw new CollectionTerminatedException();
            }
        };
    }

    public static FixedBitSet getStarTreeFilteredValues(SearchContext context, LeafReaderContext ctx, StarTreeValues starTreeValues) throws IOException {
        FixedBitSet result = context.getStarTreeQueryContext().getStarTreeValues(ctx);
        if (result == null) {
            result = StarTreeFilter.getStarTreeResult(starTreeValues, context.getStarTreeQueryContext().getQueryMap());
            context.getStarTreeQueryContext().setStarTreeValues(ctx, result);
        }
        return result;
    }
}

