/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.utils;

import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.lucene.util.IntroSorter;

public class StarTreeDocumentsSorter {
    public static void sort(final int[] sortedDocIds, final int dimensionId, int numDocs, final IntFunction<Long[]> dimensionsReader) {
        new IntroSorter(){
            private Long[] dimensions;

            protected void swap(int i, int j) {
                int temp = sortedDocIds[i];
                sortedDocIds[i] = sortedDocIds[j];
                sortedDocIds[j] = temp;
            }

            protected void setPivot(int i) {
                this.dimensions = (Long[])dimensionsReader.apply(i);
            }

            protected int comparePivot(int j) {
                Long[] currentDimensions = (Long[])dimensionsReader.apply(j);
                for (int i = dimensionId + 1; i < this.dimensions.length; ++i) {
                    Long dimension = currentDimensions[i];
                    if (Objects.equals(this.dimensions[i], dimension)) continue;
                    if (this.dimensions[i] == null && dimension == null) {
                        return 0;
                    }
                    if (dimension == null) {
                        return -1;
                    }
                    if (this.dimensions[i] == null) {
                        return 1;
                    }
                    return Long.compare(this.dimensions[i], dimension);
                }
                return 0;
            }
        }.sort(0, numDocs);
    }
}

