/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.fileformats.meta;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.opensearch.index.mapper.CompositeMappedFieldType;

public class StarTreeMetadataWriter {
    private static final Logger logger = LogManager.getLogger(StarTreeMetadataWriter.class);

    public static void writeStarTreeMetadata(IndexOutput metaOut, StarTreeField starTreeField, List<MetricAggregatorInfo> metricAggregatorInfos, Integer numNodes, Integer segmentAggregatedCount, Integer numStarTreeDocs, long dataFilePointer, long dataFileLength) throws IOException {
        long initialMetaFilePointer = metaOut.getFilePointer();
        StarTreeMetadataWriter.writeMetaHeader(metaOut);
        StarTreeMetadataWriter.writeMeta(metaOut, metricAggregatorInfos, starTreeField, numNodes, segmentAggregatedCount, numStarTreeDocs, dataFilePointer, dataFileLength);
        logger.debug("Star tree meta size in bytes : {} for star-tree field {}", (Object)(metaOut.getFilePointer() - initialMetaFilePointer), (Object)starTreeField.getName());
    }

    private static void writeMetaHeader(IndexOutput metaOut) throws IOException {
        metaOut.writeLong(3387940285652509L);
        metaOut.writeVInt(0);
    }

    private static void writeMeta(IndexOutput metaOut, List<MetricAggregatorInfo> metricAggregatorInfos, StarTreeField starTreeField, int numNodes, Integer segmentAggregatedDocCount, Integer numStarTreeDocs, long dataFilePointer, long dataFileLength) throws IOException {
        metaOut.writeString(starTreeField.getName());
        metaOut.writeString(CompositeMappedFieldType.CompositeFieldType.STAR_TREE.getName());
        metaOut.writeVInt(numNodes);
        metaOut.writeVInt(starTreeField.getDimensionNames().size());
        for (String dim : starTreeField.getDimensionNames()) {
            metaOut.writeString(dim);
        }
        metaOut.writeVInt(metricAggregatorInfos.size());
        for (MetricAggregatorInfo metricAggregatorInfo : metricAggregatorInfos) {
            metaOut.writeString(metricAggregatorInfo.getField());
            int metricStatOrdinal = metricAggregatorInfo.getMetricStat().getMetricOrdinal();
            metaOut.writeVInt(metricStatOrdinal);
        }
        metaOut.writeVInt(segmentAggregatedDocCount.intValue());
        metaOut.writeVInt(numStarTreeDocs.intValue());
        metaOut.writeVInt(starTreeField.getStarTreeConfig().maxLeafDocs());
        metaOut.writeVInt(starTreeField.getStarTreeConfig().getSkipStarNodeCreationInDims().size());
        for (String dimension : starTreeField.getStarTreeConfig().getSkipStarNodeCreationInDims()) {
            metaOut.writeString(dimension);
        }
        metaOut.writeByte(starTreeField.getStarTreeConfig().getBuildMode().getBuildModeOrdinal());
        metaOut.writeVLong(dataFilePointer);
        metaOut.writeVLong(dataFileLength);
    }
}

