/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.breaker;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class ResponseLimitSettings {
    private volatile int catIndicesResponseLimit;
    private volatile int catShardsResponseLimit;
    private volatile int catSegmentsResponseLimit;
    public static final Setting<Integer> CAT_INDICES_RESPONSE_LIMIT_SETTING = Setting.intSetting("cat.indices.response.limit.number_of_indices", -1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> CAT_SHARDS_RESPONSE_LIMIT_SETTING = Setting.intSetting("cat.shards.response.limit.number_of_shards", -1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> CAT_SEGMENTS_RESPONSE_LIMIT_SETTING = Setting.intSetting("cat.segments.response.limit.number_of_indices", -1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    static Function<Metadata, Integer> getTotalIndicesFromMetadata = metadata -> {
        if (Objects.nonNull(metadata) && Objects.nonNull(metadata.getIndices())) {
            return metadata.getIndices().size();
        }
        return 0;
    };
    static Function<RoutingTable, Integer> getTotalIndicesFromRoutingTable = routingTable -> {
        if (Objects.nonNull(routingTable) && Objects.nonNull(routingTable.getIndicesRouting())) {
            return routingTable.getIndicesRouting().size();
        }
        return 0;
    };

    public ResponseLimitSettings(ClusterSettings clusterSettings, Settings settings) {
        this.setCatShardsResponseLimit(CAT_SHARDS_RESPONSE_LIMIT_SETTING.get(settings));
        this.setCatIndicesResponseLimit(CAT_INDICES_RESPONSE_LIMIT_SETTING.get(settings));
        this.setCatSegmentsResponseLimit(CAT_SEGMENTS_RESPONSE_LIMIT_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CAT_SHARDS_RESPONSE_LIMIT_SETTING, this::setCatShardsResponseLimit);
        clusterSettings.addSettingsUpdateConsumer(CAT_INDICES_RESPONSE_LIMIT_SETTING, this::setCatIndicesResponseLimit);
        clusterSettings.addSettingsUpdateConsumer(CAT_SEGMENTS_RESPONSE_LIMIT_SETTING, this::setCatSegmentsResponseLimit);
    }

    public static boolean isResponseLimitBreached(Metadata metadata, LimitEntity limitEntity, int limit) {
        if (Objects.isNull(metadata) || limit <= 0) {
            return false;
        }
        if (limitEntity == LimitEntity.INDICES) {
            int indicesCount = getTotalIndicesFromMetadata.apply(metadata);
            return indicesCount > limit;
        }
        throw new IllegalArgumentException("Unsupported limit entity [" + limitEntity + "]");
    }

    public static boolean isResponseLimitBreached(RoutingTable routingTable, LimitEntity limitEntity, int limit) {
        if (Objects.isNull(routingTable) || limit <= 0) {
            return false;
        }
        if (Objects.isNull((Object)limitEntity)) {
            throw new IllegalArgumentException("Limit entity cannot be null");
        }
        switch (limitEntity) {
            case INDICES: {
                int indicesCount = getTotalIndicesFromRoutingTable.apply(routingTable);
                if (indicesCount <= limit) break;
                return true;
            }
            case SHARDS: {
                if (!ResponseLimitSettings.isShardsLimitBreached(routingTable, limit)) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unsupported limit entity [" + limitEntity + "]");
            }
        }
        return false;
    }

    private static boolean isShardsLimitBreached(RoutingTable routingTable, int limit) {
        Map<String, IndexRoutingTable> indexRoutingTableMap = routingTable.getIndicesRouting();
        int totalShards = 0;
        for (Map.Entry<String, IndexRoutingTable> entry : indexRoutingTableMap.entrySet()) {
            for (Map.Entry<Integer, IndexShardRoutingTable> indexShardRoutingTableEntry : entry.getValue().getShards().entrySet()) {
                if ((totalShards += indexShardRoutingTableEntry.getValue().getShards().size()) <= limit) continue;
                return true;
            }
        }
        return false;
    }

    private void setCatShardsResponseLimit(int catShardsResponseLimit) {
        this.catShardsResponseLimit = catShardsResponseLimit;
    }

    private void setCatIndicesResponseLimit(int catIndicesResponseLimit) {
        this.catIndicesResponseLimit = catIndicesResponseLimit;
    }

    private void setCatSegmentsResponseLimit(int catSegmentsResponseLimit) {
        this.catSegmentsResponseLimit = catSegmentsResponseLimit;
    }

    public int getCatShardsResponseLimit() {
        return this.catShardsResponseLimit;
    }

    public int getCatIndicesResponseLimit() {
        return this.catIndicesResponseLimit;
    }

    public int getCatSegmentsResponseLimit() {
        return this.catSegmentsResponseLimit;
    }

    public static enum LimitEntity {
        INDICES,
        SHARDS;

    }
}

