/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.annotation.processor;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.tools.Diagnostic;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.DeprecatedApi;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.annotation.PublicApi;

@SupportedAnnotationTypes(value={"org.opensearch.common.annotation.*"})
@InternalApi
public class ApiAnnotationProcessor
extends AbstractProcessor {
    private static final String OPTION_CONTINUE_ON_FAILING_CHECKS = "continueOnFailingChecks";
    private static final String OPENSEARCH_PACKAGE = "org.opensearch";
    private final Set<Element> reported = new HashSet<Element>();
    private final Set<Element> validated = new HashSet<Element>();
    private final Set<AnnotatedConstruct> processed = new HashSet<AnnotatedConstruct>();
    private Diagnostic.Kind reportFailureAs = Diagnostic.Kind.ERROR;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Set.of(OPTION_CONTINUE_ON_FAILING_CHECKS);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing OpenSearch Api annotations");
        if (this.processingEnv.getOptions().containsKey(OPTION_CONTINUE_ON_FAILING_CHECKS)) {
            this.reportFailureAs = Diagnostic.Kind.NOTE;
        }
        Set<? extends Element> elements = round.getElementsAnnotatedWithAny(Set.of(PublicApi.class, ExperimentalApi.class, DeprecatedApi.class));
        for (Element element : elements) {
            this.validate(element);
            if (!this.checkPackage(element)) continue;
            this.checkPublicVisibility(null, element);
            if (!(element instanceof TypeElement)) continue;
            this.process((TypeElement)element);
        }
        return false;
    }

    private void validate(Element element) {
        DeprecatedApi deprecatedApi;
        if (this.validated.contains(element)) {
            return;
        }
        this.validated.add(element);
        PublicApi publicApi = element.getAnnotation(PublicApi.class);
        if (publicApi != null && !this.validateVersion(publicApi.since())) {
            this.processingEnv.getMessager().printMessage(this.reportFailureAs, "The type " + element + " has @PublicApi annotation with unparseable OpenSearch version: " + publicApi.since());
        }
        if ((deprecatedApi = element.getAnnotation(DeprecatedApi.class)) != null && !this.validateVersion(deprecatedApi.since())) {
            this.processingEnv.getMessager().printMessage(this.reportFailureAs, "The type " + element + " has @DeprecatedApi annotation with unparseable OpenSearch version: " + deprecatedApi.since());
        }
    }

    private boolean validateVersion(String version) {
        String[] parts = version.split("[.-]");
        if (parts.length < 3 || parts.length > 4) {
            return false;
        }
        int major = Integer.parseInt(parts[0]);
        if (major > 3 || major < 0) {
            return false;
        }
        int minor = Integer.parseInt(parts[1]);
        if (minor < 0) {
            return false;
        }
        int patch = Integer.parseInt(parts[2]);
        return patch >= 0;
    }

    private void process(ExecutableElement executable, Element enclosing) {
        if (!this.inspectable(executable)) {
            return;
        }
        this.checkNotInternal(enclosing, executable);
        for (AnnotationMirror annotationMirror : executable.getAnnotationMirrors()) {
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!this.inspectable(element)) continue;
            this.checkNotInternal(executable.getEnclosingElement(), element);
            this.checkPublic(executable.getEnclosingElement(), element);
        }
        TypeMirror returnType = executable.getReturnType();
        if (returnType instanceof ReferenceType) {
            this.process(executable, (ReferenceType)returnType);
        }
        for (TypeMirror typeMirror : executable.getThrownTypes()) {
            if (!(typeMirror instanceof ReferenceType)) continue;
            this.process(executable, (ReferenceType)typeMirror);
        }
        for (TypeParameterElement typeParameterElement : executable.getTypeParameters()) {
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (!(typeMirror instanceof ReferenceType)) continue;
                this.process(executable, (ReferenceType)typeMirror);
            }
        }
        for (VariableElement variableElement : executable.getParameters()) {
            TypeMirror parameterType = variableElement.asType();
            if (!(parameterType instanceof ReferenceType)) continue;
            this.process(executable, (ReferenceType)parameterType);
        }
    }

    private void process(ExecutableElement executable, WildcardType type) {
        if (type.getExtendsBound() instanceof ReferenceType) {
            this.process(executable, (ReferenceType)type.getExtendsBound());
        }
        if (type.getSuperBound() instanceof ReferenceType) {
            this.process(executable, (ReferenceType)type.getSuperBound());
        }
    }

    private void process(ExecutableElement executable, ReferenceType ref) {
        if (!this.processed.add(ref)) {
            return;
        }
        if (ref instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)ref;
            Element element = declaredType.asElement();
            if (this.inspectable(element)) {
                this.checkNotInternal(executable.getEnclosingElement(), element);
                this.checkPublic(executable.getEnclosingElement(), element);
            }
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (typeMirror instanceof ReferenceType) {
                    this.process(executable, (ReferenceType)typeMirror);
                    continue;
                }
                if (!(typeMirror instanceof WildcardType)) continue;
                this.process(executable, (WildcardType)typeMirror);
            }
        } else if (ref instanceof ArrayType) {
            TypeMirror componentType = ((ArrayType)ref).getComponentType();
            if (componentType instanceof ReferenceType) {
                this.process(executable, (ReferenceType)componentType);
            }
        } else if (ref instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)ref;
            if (typeVariable.getUpperBound() instanceof ReferenceType) {
                this.process(executable, (ReferenceType)typeVariable.getUpperBound());
            }
            if (typeVariable.getLowerBound() instanceof ReferenceType) {
                this.process(executable, (ReferenceType)typeVariable.getLowerBound());
            }
        }
        for (AnnotationMirror annotationMirror : ref.getAnnotationMirrors()) {
            Element element = annotationMirror.getAnnotationType().asElement();
            if (!this.inspectable(element)) continue;
            this.checkNotInternal(executable.getEnclosingElement(), element);
            this.checkPublic(executable.getEnclosingElement(), element);
        }
    }

    private boolean inspectable(ExecutableElement executable) {
        return executable.getKind() != ElementKind.CONSTRUCTOR && executable.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private boolean inspectable(Element element) {
        PackageElement pckg = this.processingEnv.getElementUtils().getPackageOf(element);
        return pckg.getQualifiedName().toString().startsWith(OPENSEARCH_PACKAGE);
    }

    private boolean checkPackage(Element element) {
        if (this.reported.contains(element)) {
            return false;
        }
        PackageElement pckg = this.processingEnv.getElementUtils().getPackageOf(element);
        boolean belongsToOpenSearch = pckg.getQualifiedName().toString().startsWith(OPENSEARCH_PACKAGE);
        if (!belongsToOpenSearch) {
            this.reported.add(element);
            this.processingEnv.getMessager().printMessage(this.reportFailureAs, "The type " + element + " is not residing in org.opensearch.* package and should not be annotated as OpenSearch APIs.");
        }
        return belongsToOpenSearch;
    }

    private void process(Element element) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!element2.getModifiers().contains((Object)Modifier.PUBLIC) || !(element2 instanceof ExecutableElement)) continue;
            this.process((ExecutableElement)element2, element);
        }
    }

    private void checkPublic(@Nullable Element referencedBy, Element element) {
        if (this.reported.contains(element)) {
            return;
        }
        this.checkPublicVisibility(referencedBy, element);
        if (element.getAnnotation(PublicApi.class) == null && element.getAnnotation(ExperimentalApi.class) == null && element.getAnnotation(DeprecatedApi.class) == null) {
            this.reported.add(element);
            this.processingEnv.getMessager().printMessage(this.reportFailureAs, "The element " + element + " is part of the public APIs but is not marked as @PublicApi, @ExperimentalApi or @DeprecatedApi" + (String)(referencedBy != null ? " (referenced by " + referencedBy + ") " : ""));
        }
    }

    private void checkPublicVisibility(Element referencedBy, Element element) {
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            this.reported.add(element);
            this.processingEnv.getMessager().printMessage(this.reportFailureAs, "The element " + element + " is part of the public APIs but does not have public or protected visibility" + (String)(referencedBy != null ? " (referenced by " + referencedBy + ") " : ""));
        }
    }

    private void checkNotInternal(@Nullable Element referencedBy, Element element) {
        if (this.reported.contains(element)) {
            return;
        }
        if (element.getAnnotation(InternalApi.class) != null) {
            this.reported.add(element);
            this.processingEnv.getMessager().printMessage(this.reportFailureAs, "The element " + element + " is part of the public APIs but is marked as @InternalApi" + (String)(referencedBy != null ? " (referenced by " + referencedBy + ") " : ""));
        }
    }
}

