# -*- coding: binary -*-
# frozen_string_literal: true

module Rex::Proto::Secauthz
  module WellKnownSids

    # see: https://learn.microsoft.com/en-us/windows/win32/secauthz/well-known-sids

    SECURITY_NULL_SID_AUTHORITY = 'S-1-0'
    SECURITY_WORLD_SID_AUTHORITY = 'S-1-1'
    SECURITY_LOCAL_SID_AUTHORITY = 'S-1-2'
    SECURITY_CREATOR_SID_AUTHORITY = 'S-1-3'
    SECURITY_NT_AUTHORITY = 'S-1-5'

    SECURITY_NULL_RID = 0
    SECURITY_WORLD_RID = 0
    SECURITY_LOCAL_RID = 0
    SECURITY_LOCAL_LOGON_RID = 1
    SECURITY_CREATOR_OWNER_RID = 0
    SECURITY_CREATOR_GROUP_RID = 1

    SECURITY_CREATOR_OWNER_SID = "#{SECURITY_CREATOR_SID_AUTHORITY}-#{SECURITY_CREATOR_OWNER_RID}"
    SECURITY_CREATOR_GROUP_SID = "#{SECURITY_CREATOR_SID_AUTHORITY}-#{SECURITY_CREATOR_GROUP_RID}"

    SECURITY_DIALUP_SID = "#{SECURITY_NT_AUTHORITY}-1"
    SECURITY_NETWORK_SID = "#{SECURITY_NT_AUTHORITY}-2"
    SECURITY_BATCH_SID = "#{SECURITY_NT_AUTHORITY}-3"
    SECURITY_INTERACTIVE_SID = "#{SECURITY_NT_AUTHORITY}-4"
    #SECURITY_LOGON_IDS_SID = "#{SECURITY_NT_AUTHORITY}-5-X-Y"
    SECURITY_SERVICE_SID = "#{SECURITY_NT_AUTHORITY}-6"
    SECURITY_ANONYMOUS_LOGON_SID = "#{SECURITY_NT_AUTHORITY}-7"
    SECURITY_PROXY_SID = "#{SECURITY_NT_AUTHORITY}-8"
    SECURITY_ENTERPRISE_CONTROLLERS_SID = "#{SECURITY_NT_AUTHORITY}-9"
    SECURITY_PRINCIPAL_SELF_SID = "#{SECURITY_NT_AUTHORITY}-10"
    SECURITY_AUTHENTICATED_USER_SID = "#{SECURITY_NT_AUTHORITY}-11"
    SECURITY_RESTRICTED_CODE_SID = "#{SECURITY_NT_AUTHORITY}-12"
    SECURITY_TERMINAL_SERVER_SID = "#{SECURITY_NT_AUTHORITY}-13"
    SECURITY_LOCAL_SYSTEM_SID = "#{SECURITY_NT_AUTHORITY}-18"
    SECURITY_LOCAL_SERVICE_SID = "#{SECURITY_NT_AUTHORITY}-19"
    SECURITY_NETWORK_SERVICE_SID = "#{SECURITY_NT_AUTHORITY}-20"
    SECURITY_NT_NON_UNIQUE = "#{SECURITY_NT_AUTHORITY}-21"
    SECURITY_BUILTIN_DOMAIN_SID = "#{SECURITY_NT_AUTHORITY}-32"
    SECURITY_WRITE_RESTRICTED_CODE_SID = "#{SECURITY_NT_AUTHORITY}-33"

    SECURITY_USERMODEDRIVERHOST_ID_BASE_SID = "#{SECURITY_NT_AUTHORITY}-0"
    SECURITY_ALL_APP_PACKAGES = 'S-1-15-2-1'
    SECURITY_MANDATORY_SYSTEM_SID = 'S-1-16-16384'
    SECURITY_AUTHENTICATION_SERVICE_ASSERTED_SID = "S-1-18-2"

    DOMAIN_USER_RID_ADMIN = 0x000001F4
    DOMAIN_USER_RID_GUEST = 0x000001F5
    DOMAIN_GROUP_RID_ADMINS = 0x00000200
    DOMAIN_GROUP_RID_USERS = 0x00000201
    DOMAIN_GROUP_RID_GUESTS = 0x00000202
    DOMAIN_GROUP_RID_COMPUTERS = 0x00000203
    DOMAIN_GROUP_RID_CONTROLLERS = 0x00000204
    DOMAIN_GROUP_RID_CERT_ADMINS = 0x00000205
    DOMAIN_GROUP_RID_ENTERPRISE_READONLY_DOMAIN_CONTROLLERS = 0x000001F2
    DOMAIN_GROUP_RID_SCHEMA_ADMINS = 0x00000206
    DOMAIN_GROUP_RID_ENTERPRISE_ADMINS = 0x00000207
    DOMAIN_GROUP_RID_POLICY_ADMINS = 0x00000208
    DOMAIN_GROUP_RID_READONLY_CONTROLLERS = 0x00000209
    DOMAIN_GROUP_RID_CLONEABLE_CONTROLLERS = 0x0000020A
    DOMAIN_GROUP_RID_CDC_RESERVED = 0x0000020C
    DOMAIN_GROUP_RID_PROTECTED_USERS = 0x0000020D
    DOMAIN_GROUP_RID_KEY_ADMINS = 0x0000020E
    DOMAIN_GROUP_RID_ENTERPRISE_KEY_ADMINS = 0x0000020

    SECURITY_MANDATORY_UNTRUSTED_RID = 0x00000000
    SECURITY_MANDATORY_LOW_RID = 0x00001000
    SECURITY_MANDATORY_MEDIUM_RID = 0x00002000
    SECURITY_MANDATORY_MEDIUM_PLUS_RID = SECURITY_MANDATORY_MEDIUM_RID + 0x100
    SECURITY_MANDATORY_HIGH_RID = 0X00003000
    SECURITY_MANDATORY_SYSTEM_RID = 0x00004000
    SECURITY_MANDATORY_PROTECTED_PROCESS_RID = 0x00005000

    DOMAIN_ALIAS_RID_ADMINS = 0x00000220
    DOMAIN_ALIAS_RID_USERS = 0x00000221
    DOMAIN_ALIAS_RID_GUESTS = 0x00000222
    DOMAIN_ALIAS_RID_POWER_USERS = 0x00000223
    DOMAIN_ALIAS_RID_ACCOUNT_OPS = 0x00000224
    DOMAIN_ALIAS_RID_SYSTEM_OPS = 0x00000225
    DOMAIN_ALIAS_RID_PRINT_OPS = 0x00000226
    DOMAIN_ALIAS_RID_BACKUP_OPS = 0x00000227
    DOMAIN_ALIAS_RID_REPLICATOR = 0x00000228
    DOMAIN_ALIAS_RID_RAS_SERVERS = 0x00000229
    DOMAIN_ALIAS_RID_PREW2KCOMPACCESS = 0x0000022A
    DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS = 0x0000022B
    DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS = 0x0000022C
    DOMAIN_ALIAS_RID_INCOMING_FOREST_TRUST_BUILDERS = 0x0000022D
    DOMAIN_ALIAS_RID_MONITORING_USERS = 0x0000022E
    DOMAIN_ALIAS_RID_LOGGING_USERS = 0x0000022F
    DOMAIN_ALIAS_RID_AUTHORIZATIONACCESS = 0x00000230
    DOMAIN_ALIAS_RID_TS_LICENSE_SERVERS = 0x00000231
    DOMAIN_ALIAS_RID_DCOM_USERS = 0x00000232
    DOMAIN_ALIAS_RID_IUSERS = 0X00000238
    DOMAIN_ALIAS_RID_CRYPTO_OPERATORS = 0x00000239
    DOMAIN_ALIAS_RID_CACHEABLE_PRINCIPALS_GROUP = 0x0000023B
    DOMAIN_ALIAS_RID_NON_CACHEABLE_PRINCIPALS_GROUP = 0x0000023C
    DOMAIN_ALIAS_RID_EVENT_LOG_READERS_GROUP = 0x0000023D
    DOMAIN_ALIAS_RID_CERTSVC_DCOM_ACCESS_GROUP = 0x0000023E
    DOMAIN_ALIAS_RID_RDS_REMOTE_ACCESS_SERVERS = 0x0000023F
    DOMAIN_ALIAS_RID_RDS_ENDPOINT_SERVERS = 0x00000240
    DOMAIN_ALIAS_RID_RDS_MANAGEMENT_SERVERS = 0x00000241
    DOMAIN_ALIAS_RID_HYPER_V_ADMINS = 0x00000242
    DOMAIN_ALIAS_RID_ACCESS_CONTROL_ASSISTANCE_OPS = 0x00000243
    DOMAIN_ALIAS_RID_REMOTE_MANAGEMENT_USERS = 0x00000244
    DOMAIN_ALIAS_RID_DEFAULT_ACCOUNT = 0x00000245
    DOMAIN_ALIAS_RID_STORAGE_REPLICA_ADMINS = 0x00000246
    DOMAIN_ALIAS_RID_DEVICE_OWNERS = 0x00000247

    DOMAIN_ALIAS_SID_ADMINS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_ADMINS}"
    DOMAIN_ALIAS_SID_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_USERS}"
    DOMAIN_ALIAS_SID_GUESTS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_GUESTS}"
    DOMAIN_ALIAS_SID_POWER_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_POWER_USERS}"
    DOMAIN_ALIAS_SID_ACCOUNT_OPS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_ACCOUNT_OPS}"
    DOMAIN_ALIAS_SID_SYSTEM_OPS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_SYSTEM_OPS}"
    DOMAIN_ALIAS_SID_PRINT_OPS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_PRINT_OPS}"
    DOMAIN_ALIAS_SID_BACKUP_OPS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_BACKUP_OPS}"
    DOMAIN_ALIAS_SID_REPLICATOR = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_REPLICATOR}"
    DOMAIN_ALIAS_SID_RAS_SERVERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_RAS_SERVERS}"
    DOMAIN_ALIAS_SID_PREW2KCOMPACCESS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_PREW2KCOMPACCESS}"
    DOMAIN_ALIAS_SID_REMOTE_DESKTOP_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS}"
    DOMAIN_ALIAS_SID_NETWORK_CONFIGURATION_OPS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS}"
    DOMAIN_ALIAS_SID_INCOMING_FOREST_TRUST_BUILDERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_INCOMING_FOREST_TRUST_BUILDERS}"
    DOMAIN_ALIAS_SID_MONITORING_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_MONITORING_USERS}"
    DOMAIN_ALIAS_SID_LOGGING_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_LOGGING_USERS}"
    DOMAIN_ALIAS_SID_AUTHORIZATIONACCESS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_AUTHORIZATIONACCESS}"
    DOMAIN_ALIAS_SID_TS_LICENSE_SERVERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_TS_LICENSE_SERVERS}"
    DOMAIN_ALIAS_SID_DCOM_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_DCOM_USERS}"
    DOMAIN_ALIAS_SID_IUSERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_IUSERS}"
    DOMAIN_ALIAS_SID_CRYPTO_OPERATORS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_CRYPTO_OPERATORS}"
    DOMAIN_ALIAS_SID_CACHEABLE_PRINCIPALS_GROUP = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_CACHEABLE_PRINCIPALS_GROUP}"
    DOMAIN_ALIAS_SID_NON_CACHEABLE_PRINCIPALS_GROUP = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_NON_CACHEABLE_PRINCIPALS_GROUP}"
    DOMAIN_ALIAS_SID_EVENT_LOG_READERS_GROUP = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_EVENT_LOG_READERS_GROUP}"
    DOMAIN_ALIAS_SID_CERTSVC_DCOM_ACCESS_GROUP = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_CERTSVC_DCOM_ACCESS_GROUP}"
    DOMAIN_ALIAS_SID_RDS_REMOTE_ACCESS_SERVERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_RDS_REMOTE_ACCESS_SERVERS}"
    DOMAIN_ALIAS_SID_RDS_ENDPOINT_SERVERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_RDS_ENDPOINT_SERVERS}"
    DOMAIN_ALIAS_SID_RDS_MANAGEMENT_SERVERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_RDS_MANAGEMENT_SERVERS}"
    DOMAIN_ALIAS_SID_HYPER_V_ADMINS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_HYPER_V_ADMINS}"
    DOMAIN_ALIAS_SID_ACCESS_CONTROL_ASSISTANCE_OPS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_ACCESS_CONTROL_ASSISTANCE_OPS}"
    DOMAIN_ALIAS_SID_REMOTE_MANAGEMENT_USERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_REMOTE_MANAGEMENT_USERS}"
    DOMAIN_ALIAS_SID_DEFAULT_ACCOUNT = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_DEFAULT_ACCOUNT}"
    DOMAIN_ALIAS_SID_STORAGE_REPLICA_ADMINS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_STORAGE_REPLICA_ADMINS}"
    DOMAIN_ALIAS_SID_DEVICE_OWNERS = "#{SECURITY_BUILTIN_DOMAIN_SID}-#{DOMAIN_ALIAS_RID_DEVICE_OWNERS}"

  end
end
