# -*- coding: binary -*-

module Msf
  module Exploit::Local::SapSmdAgentUnencryptedProperty
    def parse_properties(file_content)
      results = []
      rows = file_content.split(/\n+/)
      rows.each do |row|
        property = row.match(/(?<name>.*[^\\])=(?<value>.*)/)
        next if property.nil?

        property_name = property[:name]
        property_value = property[:value].strip
        if property_name =~ %r{(smd/agent/|sld/usr|sld/pwd)}i
          # BASE64 decode and parse property value
          string_type, string_len, string_val = Rex::Text.decode_base64(property[:value].sub('\\=', '=')).split(/\|/)
          if string_len.to_i > 0 && string_type == 'java.lang.String'
            property_value = string_val.first(string_len.to_i)
          else
            property_value = nil
          end
        end
        results.push({
          name: property_name,
          value: property_value
        })
      end
      results
    end
  end
end
