#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 kmonad
version:              0.4.3
visibility:           public
id:                   kmonad-0.4.3-2X5oFnaaMZ82q6YZyaHZxE
key:                  kmonad-0.4.3-2X5oFnaaMZ82q6YZyaHZxE
license:              MIT
maintainer:           janssen.dhj@gmail.com
author:               David Janssen
synopsis:             Advanced keyboard remapping utility
description:
    KMonad is a cross-platform command-line utility that runs as a daemon. It
    captures keyboard input (exactly how depends on the OS) and remaps it. The
    mapping is highly configurable, and provides options like (transparent) layer
    overlays, tap-mod buttons, multi-tap buttons, leader-key style buttons, and
    keyboard macros. Functionality heavily inspired by the QMK-firmware.

category:             Application
abi:                  e5a54cb9dc2c550df2db51dbaa7c7804
exposed:              True
exposed-modules:
    KMonad.App KMonad.App.Main KMonad.App.Types KMonad.Args
    KMonad.Args.Cmd KMonad.Args.Joiner KMonad.Args.Parser
    KMonad.Args.TH KMonad.Args.Types KMonad.Gesture KMonad.Keyboard
    KMonad.Keyboard.ComposeSeq KMonad.Keyboard.IO
    KMonad.Keyboard.IO.Linux.DeviceSource
    KMonad.Keyboard.IO.Linux.Types KMonad.Keyboard.IO.Linux.UinputSink
    KMonad.Keyboard.Keycode KMonad.Keyboard.Ops KMonad.Keyboard.Types
    KMonad.Model KMonad.Model.Action KMonad.Model.BEnv
    KMonad.Model.Button KMonad.Model.Dispatch KMonad.Model.Hooks
    KMonad.Model.Keymap KMonad.Model.Sluice KMonad.Parsing
    KMonad.Prelude KMonad.Prelude.Definitions KMonad.Prelude.Imports
    KMonad.Util KMonad.Util.LayerStack KMonad.Util.MultiMap
    Paths_kmonad

import-dirs:          /usr/lib/ghc-9.2.8/site-local/kmonad-0.4.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/kmonad-0.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/kmonad
hs-libraries:         HSkmonad-0.4.3-2X5oFnaaMZ82q6YZyaHZxE
depends:
    base-4.16.4.0 cereal-0.5.8.3-9zcITCTkqXtHoa6jbeSF22
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt mtl-2.2.2
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb
    resourcet-1.2.6-AIugU9tehxw9mXWKxKfb0b
    rio-0.1.22.0-5OsachK9yMc5wVwvzEShe5 template-haskell-2.18.0.0
    time-1.11.1.1 unix-2.7.2.2 unliftio-0.2.25.0-I5KL8dbXVmE3dWILMxzDhI

haddock-interfaces:   /usr/share/doc/kmonad/html/kmonad.haddock
haddock-html:         /usr/share/doc/kmonad/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

