/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.LogHistory;
import org.apache.kafka.raft.internals.TreeMapLogHistory;

public final class VoterSetHistory {
    private final VoterSet staticVoterSet;
    private final LogHistory<VoterSet> votersHistory = new TreeMapLogHistory<VoterSet>();

    VoterSetHistory(VoterSet staticVoterSet) {
        this.staticVoterSet = staticVoterSet;
    }

    public void addAt(long offset, VoterSet voters) {
        VoterSet lastVoterSet;
        Optional<LogHistory.Entry<VoterSet>> lastEntry = this.votersHistory.lastEntry();
        if (lastEntry.isPresent() && lastEntry.get().offset() >= 0L && !(lastVoterSet = lastEntry.get().value()).hasOverlappingMajority(voters)) {
            throw new IllegalArgumentException(String.format("Last voter set %s doesn't have an overlapping majority with the new voter set %s", lastVoterSet, voters));
        }
        this.votersHistory.addAt(offset, voters);
    }

    public Optional<VoterSet> valueAtOrBefore(long offset) {
        return this.votersHistory.valueAtOrBefore(offset);
    }

    public VoterSet lastValue() {
        return this.votersHistory.lastEntry().map(LogHistory.Entry::value).orElse(this.staticVoterSet);
    }

    public Optional<LogHistory.Entry<VoterSet>> lastEntry() {
        return this.votersHistory.lastEntry();
    }

    public OptionalLong lastVoterSetOffset() {
        Optional<LogHistory.Entry<VoterSet>> lastEntry = this.votersHistory.lastEntry();
        if (lastEntry.isPresent()) {
            return OptionalLong.of(lastEntry.get().offset());
        }
        return OptionalLong.empty();
    }

    public void truncateNewEntries(long endOffset) {
        this.votersHistory.truncateNewEntries(endOffset);
    }

    public void truncateOldEntries(long startOffset) {
        this.votersHistory.truncateOldEntries(startOffset);
    }

    public void clear() {
        this.votersHistory.clear();
    }
}

