/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Values {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final SchemaAndValue NULL_SCHEMA_AND_VALUE = new SchemaAndValue(null, null);
    private static final Schema ARRAY_SELECTOR_SCHEMA = SchemaBuilder.array(Schema.STRING_SCHEMA).build();
    private static final Schema MAP_SELECTOR_SCHEMA = SchemaBuilder.map(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA).build();
    private static final Schema STRUCT_SELECTOR_SCHEMA = SchemaBuilder.struct().build();
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final String NULL_VALUE = "null";
    static final String ISO_8601_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    static final String ISO_8601_TIME_FORMAT_PATTERN = "HH:mm:ss.SSS'Z'";
    static final String ISO_8601_TIMESTAMP_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Pattern TWO_BACKSLASHES = Pattern.compile("\\\\");
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\"");

    public static Boolean convertToBoolean(Schema schema, Object value) throws DataException {
        SchemaAndValue parsed;
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && (parsed = Values.parseString(value.toString())).value() instanceof Boolean) {
            return (Boolean)parsed.value();
        }
        return Values.asLong(value, schema, null) == 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Byte convertToByte(Schema schema, Object value) throws DataException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return (byte)Values.asLong(value, schema, null);
    }

    public static Short convertToShort(Schema schema, Object value) throws DataException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        return (short)Values.asLong(value, schema, null);
    }

    public static Integer convertToInteger(Schema schema, Object value) throws DataException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return (int)Values.asLong(value, schema, null);
    }

    public static Long convertToLong(Schema schema, Object value) throws DataException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Values.asLong(value, schema, null);
    }

    public static Float convertToFloat(Schema schema, Object value) throws DataException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        return Float.valueOf((float)Values.asDouble(value, schema, null));
    }

    public static Double convertToDouble(Schema schema, Object value) throws DataException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return Values.asDouble(value, schema, null);
    }

    public static String convertToString(Schema schema, Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Values.append(sb, value, false);
        return sb.toString();
    }

    public static List<?> convertToList(Schema schema, Object value) {
        return Values.convertToArray(ARRAY_SELECTOR_SCHEMA, value);
    }

    public static Map<?, ?> convertToMap(Schema schema, Object value) {
        return Values.convertToMapInternal(MAP_SELECTOR_SCHEMA, value);
    }

    public static Struct convertToStruct(Schema schema, Object value) {
        return Values.convertToStructInternal(STRUCT_SELECTOR_SCHEMA, value);
    }

    public static java.util.Date convertToTime(Schema schema, Object value) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        return Values.convertToTime(Time.SCHEMA, schema, value);
    }

    public static java.util.Date convertToDate(Schema schema, Object value) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        return Values.convertToDate(Date.SCHEMA, schema, value);
    }

    public static java.util.Date convertToTimestamp(Schema schema, Object value) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        return Values.convertToTimestamp(Timestamp.SCHEMA, schema, value);
    }

    public static BigDecimal convertToDecimal(Schema schema, Object value, int scale) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        return Values.convertToDecimal(Decimal.schema(scale), value);
    }

    public static Schema inferSchema(Object value) {
        if (value instanceof String) {
            return Schema.STRING_SCHEMA;
        }
        if (value instanceof Boolean) {
            return Schema.BOOLEAN_SCHEMA;
        }
        if (value instanceof Byte) {
            return Schema.INT8_SCHEMA;
        }
        if (value instanceof Short) {
            return Schema.INT16_SCHEMA;
        }
        if (value instanceof Integer) {
            return Schema.INT32_SCHEMA;
        }
        if (value instanceof Long) {
            return Schema.INT64_SCHEMA;
        }
        if (value instanceof Float) {
            return Schema.FLOAT32_SCHEMA;
        }
        if (value instanceof Double) {
            return Schema.FLOAT64_SCHEMA;
        }
        if (value instanceof byte[] || value instanceof ByteBuffer) {
            return Schema.BYTES_SCHEMA;
        }
        if (value instanceof List) {
            return Values.inferListSchema((List)value);
        }
        if (value instanceof Map) {
            return Values.inferMapSchema((Map)value);
        }
        if (value instanceof Struct) {
            return ((Struct)value).schema();
        }
        return null;
    }

    private static Schema inferListSchema(List<?> list) {
        if (list.isEmpty()) {
            return null;
        }
        SchemaDetector detector = new SchemaDetector();
        for (Object element : list) {
            if (detector.canDetect(element)) continue;
            return null;
        }
        return SchemaBuilder.array(detector.schema()).build();
    }

    private static Schema inferMapSchema(Map<?, ?> map) {
        if (map.isEmpty()) {
            return null;
        }
        SchemaDetector keyDetector = new SchemaDetector();
        SchemaDetector valueDetector = new SchemaDetector();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (keyDetector.canDetect(entry.getKey()) && valueDetector.canDetect(entry.getValue())) continue;
            return null;
        }
        return SchemaBuilder.map(keyDetector.schema(), valueDetector.schema()).build();
    }

    public static SchemaAndValue parseString(String value) {
        if (value == null) {
            return NULL_SCHEMA_AND_VALUE;
        }
        if (value.isEmpty()) {
            return new SchemaAndValue(Schema.STRING_SCHEMA, value);
        }
        ValueParser parser = new ValueParser(new Parser(value));
        return parser.parse(false);
    }

    protected static Object convertTo(Schema toSchema, Schema fromSchema, Object value) throws DataException {
        if (value == null) {
            if (toSchema.isOptional()) {
                return null;
            }
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        switch (toSchema.type()) {
            case BYTES: {
                return Values.convertMaybeLogicalBytes(toSchema, value);
            }
            case STRING: {
                return Values.convertToString(fromSchema, value);
            }
            case BOOLEAN: {
                return Values.convertToBoolean(fromSchema, value);
            }
            case INT8: {
                return Values.convertToByte(fromSchema, value);
            }
            case INT16: {
                return Values.convertToShort(fromSchema, value);
            }
            case INT32: {
                return Values.convertMaybeLogicalInteger(toSchema, fromSchema, value);
            }
            case INT64: {
                return Values.convertMaybeLogicalLong(toSchema, fromSchema, value);
            }
            case FLOAT32: {
                return Values.convertToFloat(fromSchema, value);
            }
            case FLOAT64: {
                return Values.convertToDouble(fromSchema, value);
            }
            case ARRAY: {
                return Values.convertToArray(toSchema, value);
            }
            case MAP: {
                return Values.convertToMapInternal(toSchema, value);
            }
            case STRUCT: {
                return Values.convertToStructInternal(toSchema, value);
            }
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    private static Serializable convertMaybeLogicalBytes(Schema toSchema, Object value) {
        if ("org.apache.kafka.connect.data.Decimal".equals(toSchema.name())) {
            return Values.convertToDecimal(toSchema, value);
        }
        return Values.convertToBytes(toSchema, value);
    }

    private static BigDecimal convertToDecimal(Schema toSchema, Object value) {
        if (value instanceof ByteBuffer) {
            value = Utils.toArray((ByteBuffer)((ByteBuffer)value));
        }
        if (value instanceof byte[]) {
            return Decimal.toLogical(toSchema, (byte[])value);
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            double converted = ((Number)value).doubleValue();
            return BigDecimal.valueOf(converted);
        }
        if (value instanceof String) {
            return new BigDecimal(value.toString());
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    private static byte[] convertToBytes(Schema toSchema, Object value) {
        if (value instanceof ByteBuffer) {
            return Utils.toArray((ByteBuffer)((ByteBuffer)value));
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof BigDecimal) {
            return Decimal.fromLogical(toSchema, (BigDecimal)value);
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    private static Serializable convertMaybeLogicalInteger(Schema toSchema, Schema fromSchema, Object value) {
        if ("org.apache.kafka.connect.data.Date".equals(toSchema.name())) {
            return Values.convertToDate(toSchema, fromSchema, value);
        }
        if ("org.apache.kafka.connect.data.Time".equals(toSchema.name())) {
            return Values.convertToTime(toSchema, fromSchema, value);
        }
        return Values.convertToInteger(fromSchema, value);
    }

    private static java.util.Date convertToDate(Schema toSchema, Schema fromSchema, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            SchemaAndValue parsed = Values.parseString(value.toString());
            value = parsed.value();
        }
        if (value instanceof java.util.Date) {
            if (fromSchema != null) {
                String fromSchemaName = fromSchema.name();
                if ("org.apache.kafka.connect.data.Date".equals(fromSchemaName)) {
                    return (java.util.Date)value;
                }
                if ("org.apache.kafka.connect.data.Timestamp".equals(fromSchemaName)) {
                    long millis = ((java.util.Date)value).getTime();
                    int days = (int)(millis / 86400000L);
                    return Date.toLogical(toSchema, days);
                }
            } else {
                return (java.util.Date)value;
            }
        }
        long numeric = Values.asLong(value, fromSchema, null);
        return Date.toLogical(toSchema, (int)numeric);
    }

    private static java.util.Date convertToTime(Schema toSchema, Schema fromSchema, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            SchemaAndValue parsed = Values.parseString(value.toString());
            value = parsed.value();
        }
        if (value instanceof java.util.Date) {
            if (fromSchema != null) {
                String fromSchemaName = fromSchema.name();
                if ("org.apache.kafka.connect.data.Time".equals(fromSchemaName)) {
                    return (java.util.Date)value;
                }
                if ("org.apache.kafka.connect.data.Timestamp".equals(fromSchemaName)) {
                    Calendar calendar = Calendar.getInstance(UTC);
                    calendar.setTime((java.util.Date)value);
                    calendar.set(1, 1970);
                    calendar.set(2, 0);
                    calendar.set(5, 1);
                    return Time.toLogical(toSchema, (int)calendar.getTimeInMillis());
                }
            } else {
                return (java.util.Date)value;
            }
        }
        long numeric = Values.asLong(value, fromSchema, null);
        return Time.toLogical(toSchema, (int)numeric);
    }

    private static Serializable convertMaybeLogicalLong(Schema toSchema, Schema fromSchema, Object value) {
        if ("org.apache.kafka.connect.data.Timestamp".equals(toSchema.name())) {
            return Values.convertToTimestamp(toSchema, fromSchema, value);
        }
        return Values.convertToLong(fromSchema, value);
    }

    private static java.util.Date convertToTimestamp(Schema toSchema, Schema fromSchema, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            SchemaAndValue parsed = Values.parseString(value.toString());
            value = parsed.value();
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            if (fromSchema != null) {
                String fromSchemaName = fromSchema.name();
                if ("org.apache.kafka.connect.data.Date".equals(fromSchemaName)) {
                    int days = Date.fromLogical(fromSchema, date);
                    long millis = (long)days * 86400000L;
                    return Timestamp.toLogical(toSchema, millis);
                }
                if ("org.apache.kafka.connect.data.Time".equals(fromSchemaName)) {
                    long millis = Time.fromLogical(fromSchema, date);
                    return Timestamp.toLogical(toSchema, millis);
                }
                if ("org.apache.kafka.connect.data.Timestamp".equals(fromSchemaName)) {
                    return date;
                }
            } else {
                return date;
            }
        }
        long numeric = Values.asLong(value, fromSchema, null);
        return Timestamp.toLogical(toSchema, numeric);
    }

    private static List<?> convertToArray(Schema toSchema, Object value) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        if (value instanceof String) {
            SchemaAndValue schemaAndValue = Values.parseString(value.toString());
            value = schemaAndValue.value();
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    private static Map<?, ?> convertToMapInternal(Schema toSchema, Object value) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        if (value instanceof String) {
            SchemaAndValue schemaAndValue = Values.parseString(value.toString());
            value = schemaAndValue.value();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    private static Struct convertToStructInternal(Schema toSchema, Object value) {
        if (value == null) {
            throw new DataException("Unable to convert a null value to a schema that requires a value");
        }
        if (value instanceof Struct) {
            return (Struct)value;
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + toSchema);
    }

    protected static long asLong(Object value, Schema fromSchema, Throwable error) {
        try {
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.longValue();
            }
            if (value instanceof String) {
                return new BigDecimal(value.toString()).longValue();
            }
        }
        catch (NumberFormatException e) {
            error = e;
        }
        if (fromSchema != null) {
            String schemaName = fromSchema.name();
            if (value instanceof java.util.Date) {
                if ("org.apache.kafka.connect.data.Date".equals(schemaName)) {
                    return Date.fromLogical(fromSchema, (java.util.Date)value);
                }
                if ("org.apache.kafka.connect.data.Time".equals(schemaName)) {
                    return Time.fromLogical(fromSchema, (java.util.Date)value);
                }
                if ("org.apache.kafka.connect.data.Timestamp".equals(schemaName)) {
                    return Timestamp.fromLogical(fromSchema, (java.util.Date)value);
                }
            }
            throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to " + fromSchema, error);
        }
        throw new DataException("Unable to convert " + value + " (" + value.getClass() + ") to a number", error);
    }

    protected static double asDouble(Object value, Schema schema, Throwable error) {
        try {
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.doubleValue();
            }
            if (value instanceof String) {
                return new BigDecimal(value.toString()).doubleValue();
            }
        }
        catch (NumberFormatException e) {
            error = e;
        }
        return Values.asLong(value, schema, error);
    }

    protected static void append(StringBuilder sb, Object value, boolean embedded) {
        if (value == null) {
            sb.append(NULL_VALUE);
        } else if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof Boolean) {
            sb.append(value);
        } else if (value instanceof String) {
            if (embedded) {
                String escaped = Values.escape((String)value);
                sb.append('\"').append(escaped).append('\"');
            } else {
                sb.append(value);
            }
        } else if (value instanceof byte[]) {
            value = Base64.getEncoder().encodeToString((byte[])value);
            if (embedded) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
        } else if (value instanceof ByteBuffer) {
            byte[] bytes = Utils.readBytes((ByteBuffer)((ByteBuffer)value));
            Values.append(sb, bytes, embedded);
        } else if (value instanceof List) {
            List list = (List)value;
            sb.append('[');
            Values.appendIterable(sb, list.iterator());
            sb.append(']');
        } else if (value instanceof Map) {
            Map map = (Map)value;
            sb.append('{');
            Values.appendIterable(sb, map.entrySet().iterator());
            sb.append('}');
        } else if (value instanceof Struct) {
            Struct struct = (Struct)value;
            Schema schema = struct.schema();
            boolean first = true;
            sb.append('{');
            for (Field field : schema.fields()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                Values.append(sb, field.name(), true);
                sb.append(':');
                Values.append(sb, struct.get(field), true);
            }
            sb.append('}');
        } else if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            Values.append(sb, entry.getKey(), true);
            sb.append(':');
            Values.append(sb, entry.getValue(), true);
        } else if (value instanceof java.util.Date) {
            java.util.Date dateValue = (java.util.Date)value;
            String formatted = Values.dateFormatFor(dateValue).format(dateValue);
            sb.append(formatted);
        } else {
            throw new DataException("Failed to serialize unexpected value type " + value.getClass().getName() + ": " + value);
        }
    }

    protected static void appendIterable(StringBuilder sb, Iterator<?> iter) {
        if (iter.hasNext()) {
            Values.append(sb, iter.next(), true);
            while (iter.hasNext()) {
                sb.append(',');
                Values.append(sb, iter.next(), true);
            }
        }
    }

    protected static String escape(String value) {
        String replace1 = TWO_BACKSLASHES.matcher(value).replaceAll("\\\\\\\\");
        return DOUBLE_QUOTE.matcher(replace1).replaceAll("\\\\\"");
    }

    public static DateFormat dateFormatFor(java.util.Date value) {
        if (value.getTime() < 86400000L) {
            return new SimpleDateFormat(ISO_8601_TIME_FORMAT_PATTERN);
        }
        if (value.getTime() % 86400000L == 0L) {
            return new SimpleDateFormat(ISO_8601_DATE_FORMAT_PATTERN);
        }
        return new SimpleDateFormat(ISO_8601_TIMESTAMP_FORMAT_PATTERN);
    }

    private static Schema mergeSchemas(Schema previous, Schema newSchema) {
        Schema.Type newType;
        Schema.Type previousType = previous.type();
        if (previousType != (newType = newSchema.type())) {
            switch (previous.type()) {
                case INT8: {
                    return Values.commonSchemaForInt8(newSchema, newType);
                }
                case INT16: {
                    return Values.commonSchemaForInt16(previous, newSchema, newType);
                }
                case INT32: {
                    return Values.commonSchemaForInt32(previous, newSchema, newType);
                }
                case INT64: {
                    return Values.commonSchemaForInt64(previous, newSchema, newType);
                }
                case FLOAT32: {
                    return Values.commonSchemaForFloat32(previous, newSchema, newType);
                }
                case FLOAT64: {
                    return Values.commonSchemaForFloat64(previous, newType);
                }
            }
            return null;
        }
        if (previous.isOptional() == newSchema.isOptional()) {
            return previous.isOptional() ? previous : newSchema;
        }
        if (!previous.equals(newSchema)) {
            return null;
        }
        return previous;
    }

    private static Schema commonSchemaForInt8(Schema newSchema, Schema.Type newType) {
        if (newType == Schema.Type.INT16 || newType == Schema.Type.INT32 || newType == Schema.Type.INT64 || newType == Schema.Type.FLOAT32 || newType == Schema.Type.FLOAT64) {
            return newSchema;
        }
        return null;
    }

    private static Schema commonSchemaForInt16(Schema previous, Schema newSchema, Schema.Type newType) {
        if (newType == Schema.Type.INT8) {
            return previous;
        }
        if (newType == Schema.Type.INT32 || newType == Schema.Type.INT64 || newType == Schema.Type.FLOAT32 || newType == Schema.Type.FLOAT64) {
            return newSchema;
        }
        return null;
    }

    private static Schema commonSchemaForInt32(Schema previous, Schema newSchema, Schema.Type newType) {
        if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16) {
            return previous;
        }
        if (newType == Schema.Type.INT64 || newType == Schema.Type.FLOAT32 || newType == Schema.Type.FLOAT64) {
            return newSchema;
        }
        return null;
    }

    private static Schema commonSchemaForInt64(Schema previous, Schema newSchema, Schema.Type newType) {
        if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16 || newType == Schema.Type.INT32) {
            return previous;
        }
        if (newType == Schema.Type.FLOAT32 || newType == Schema.Type.FLOAT64) {
            return newSchema;
        }
        return null;
    }

    private static Schema commonSchemaForFloat32(Schema previous, Schema newSchema, Schema.Type newType) {
        if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16 || newType == Schema.Type.INT32 || newType == Schema.Type.INT64) {
            return previous;
        }
        if (newType == Schema.Type.FLOAT64) {
            return newSchema;
        }
        return null;
    }

    private static Schema commonSchemaForFloat64(Schema previous, Schema.Type newType) {
        if (newType == Schema.Type.INT8 || newType == Schema.Type.INT16 || newType == Schema.Type.INT32 || newType == Schema.Type.INT64 || newType == Schema.Type.FLOAT32) {
            return previous;
        }
        return null;
    }

    protected static List<Object> alignListEntriesWithSchema(Schema schema, List<Object> input) {
        Schema valueSchema = schema.valueSchema();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : input) {
            Object newValue = Values.convertTo(valueSchema, null, value);
            result.add(newValue);
        }
        return result;
    }

    protected static Map<Object, Object> alignMapKeysAndValuesWithSchema(Schema mapSchema, Map<Object, Object> input) {
        Schema keySchema = mapSchema.keySchema();
        Schema valueSchema = mapSchema.valueSchema();
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : input.entrySet()) {
            Object newKey = Values.convertTo(keySchema, null, entry.getKey());
            Object newValue = Values.convertTo(valueSchema, null, entry.getValue());
            result.put(newKey, newValue);
        }
        return result;
    }

    protected static Map<Object, Object> alignMapKeysWithSchema(Schema mapSchema, Map<Object, Object> input) {
        Schema keySchema = mapSchema.keySchema();
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : input.entrySet()) {
            Object newKey = Values.convertTo(keySchema, null, entry.getKey());
            result.put(newKey, entry.getValue());
        }
        return result;
    }

    protected static class SchemaDetector {
        private Schema.Type knownType = null;
        private boolean optional = false;

        public boolean canDetect(Object value) {
            if (value == null) {
                this.optional = true;
                return true;
            }
            Schema schema = Values.inferSchema(value);
            if (schema == null) {
                return false;
            }
            if (this.knownType == null) {
                this.knownType = schema.type();
            } else if (this.knownType != schema.type()) {
                return false;
            }
            return true;
        }

        public Schema schema() {
            SchemaBuilder builder = SchemaBuilder.type(this.knownType);
            if (this.optional) {
                builder.optional();
            }
            return builder.schema();
        }
    }

    private static class ValueParser {
        private static final Logger log = LoggerFactory.getLogger(ValueParser.class);
        private static final SchemaAndValue TRUE_SCHEMA_AND_VALUE = new SchemaAndValue(Schema.BOOLEAN_SCHEMA, Boolean.TRUE);
        private static final SchemaAndValue FALSE_SCHEMA_AND_VALUE = new SchemaAndValue(Schema.BOOLEAN_SCHEMA, Boolean.FALSE);
        private static final String TRUE_LITERAL = Boolean.TRUE.toString();
        private static final String FALSE_LITERAL = Boolean.FALSE.toString();
        private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
        private static final String QUOTE_DELIMITER = "\"";
        private static final String COMMA_DELIMITER = ",";
        private static final String ENTRY_DELIMITER = ":";
        private static final String ARRAY_BEGIN_DELIMITER = "[";
        private static final String ARRAY_END_DELIMITER = "]";
        private static final String MAP_BEGIN_DELIMITER = "{";
        private static final String MAP_END_DELIMITER = "}";
        private static final int ISO_8601_DATE_LENGTH = "yyyy-MM-dd".length();
        private static final int ISO_8601_TIME_LENGTH = "HH:mm:ss.SSS'Z'".length() - 2;
        private static final int ISO_8601_TIMESTAMP_LENGTH = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length() - 4;
        private final Parser parser;

        private ValueParser(Parser parser) {
            this.parser = parser;
        }

        private boolean canParseSingleTokenLiteral(boolean embedded, String tokenLiteral) {
            int startPosition = this.parser.mark();
            if (this.parser.canConsume(tokenLiteral) && (embedded || !this.parser.hasNext())) {
                return true;
            }
            this.parser.rewindTo(startPosition);
            return false;
        }

        public SchemaAndValue parse(boolean embedded) throws NoSuchElementException {
            if (!this.parser.hasNext()) {
                return null;
            }
            if (embedded && this.parser.canConsume(QUOTE_DELIMITER)) {
                return this.parseQuotedString();
            }
            if (this.canParseSingleTokenLiteral(embedded, Values.NULL_VALUE)) {
                return null;
            }
            if (this.canParseSingleTokenLiteral(embedded, TRUE_LITERAL)) {
                return TRUE_SCHEMA_AND_VALUE;
            }
            if (this.canParseSingleTokenLiteral(embedded, FALSE_LITERAL)) {
                return FALSE_SCHEMA_AND_VALUE;
            }
            int startPosition = this.parser.mark();
            try {
                if (this.parser.canConsume(ARRAY_BEGIN_DELIMITER)) {
                    return this.parseArray();
                }
                if (this.parser.canConsume(MAP_BEGIN_DELIMITER)) {
                    return this.parseMap();
                }
            }
            catch (DataException e) {
                log.trace("Unable to parse the value as a map or an array; reverting to string", (Throwable)((Object)e));
                this.parser.rewindTo(startPosition);
            }
            String token = this.parser.next();
            if (Utils.isBlank((String)token)) {
                return new SchemaAndValue(Schema.STRING_SCHEMA, token);
            }
            return this.parseNextToken(embedded, token.trim());
        }

        private SchemaAndValue parseNextToken(boolean embedded, String token) {
            SchemaAndValue temporal;
            char firstChar = token.charAt(0);
            boolean firstCharIsDigit = Character.isDigit(firstChar);
            if (firstCharIsDigit && (temporal = this.parseMultipleTokensAsTemporal(token)) != null) {
                return temporal;
            }
            if (firstCharIsDigit || firstChar == '+' || firstChar == '-') {
                try {
                    return ValueParser.parseAsNumber(token);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (embedded) {
                throw new DataException("Failed to parse embedded value");
            }
            return new SchemaAndValue(Schema.STRING_SCHEMA, this.parser.original());
        }

        private SchemaAndValue parseQuotedString() {
            StringBuilder sb = new StringBuilder();
            while (this.parser.hasNext() && !this.parser.canConsume(QUOTE_DELIMITER)) {
                sb.append(this.parser.next());
            }
            String content = sb.toString();
            SchemaAndValue parsed = ValueParser.parseAsTemporal(content);
            if (parsed != null) {
                return parsed;
            }
            return new SchemaAndValue(Schema.STRING_SCHEMA, content);
        }

        private SchemaAndValue parseArray() {
            List<Object> result = new ArrayList<Object>();
            SchemaMerger elementSchema = new SchemaMerger();
            while (this.parser.hasNext()) {
                if (this.parser.canConsume(ARRAY_END_DELIMITER)) {
                    Schema listSchema;
                    if (elementSchema.hasCommonSchema()) {
                        listSchema = SchemaBuilder.array(elementSchema.schema()).schema();
                        result = Values.alignListEntriesWithSchema(listSchema, result);
                    } else {
                        listSchema = SchemaBuilder.arrayOfNull().build();
                    }
                    return new SchemaAndValue(listSchema, result);
                }
                if (this.parser.canConsume(COMMA_DELIMITER)) {
                    throw new DataException("Unable to parse an empty array element: " + this.parser.original());
                }
                SchemaAndValue element = this.parse(true);
                elementSchema.merge(element);
                result.add(element != null ? element.value() : null);
                int currentPosition = this.parser.mark();
                if (this.parser.canConsume(ARRAY_END_DELIMITER)) {
                    this.parser.rewindTo(currentPosition);
                    continue;
                }
                if (this.parser.canConsume(COMMA_DELIMITER)) continue;
                throw new DataException("Array elements missing ',' delimiter");
            }
            if (COMMA_DELIMITER.equals(this.parser.previous())) {
                throw new DataException("Array is missing element after ',': " + this.parser.original());
            }
            throw new DataException("Array is missing terminating ']': " + this.parser.original());
        }

        private SchemaAndValue parseMap() {
            Map<Object, Object> result = new LinkedHashMap<Object, Object>();
            SchemaMerger keySchema = new SchemaMerger();
            SchemaMerger valueSchema = new SchemaMerger();
            while (this.parser.hasNext()) {
                if (this.parser.canConsume(MAP_END_DELIMITER)) {
                    Schema mapSchema;
                    if (keySchema.hasCommonSchema() && valueSchema.hasCommonSchema()) {
                        mapSchema = SchemaBuilder.map(keySchema.schema(), valueSchema.schema()).build();
                        result = Values.alignMapKeysAndValuesWithSchema(mapSchema, result);
                    } else if (keySchema.hasCommonSchema()) {
                        mapSchema = SchemaBuilder.mapWithNullValues(keySchema.schema());
                        result = Values.alignMapKeysWithSchema(mapSchema, result);
                    } else {
                        mapSchema = SchemaBuilder.mapOfNull().build();
                    }
                    return new SchemaAndValue(mapSchema, result);
                }
                if (this.parser.canConsume(COMMA_DELIMITER)) {
                    throw new DataException("Unable to parse a map entry with no key or value: " + this.parser.original());
                }
                SchemaAndValue key = this.parse(true);
                if (key == null || key.value() == null) {
                    throw new DataException("Map entry may not have a null key: " + this.parser.original());
                }
                if (!this.parser.canConsume(ENTRY_DELIMITER)) {
                    throw new DataException("Map entry is missing ':' at " + this.parser.position() + " in " + this.parser.original());
                }
                SchemaAndValue value = this.parse(true);
                Object entryValue = value != null ? value.value() : null;
                result.put(key.value(), entryValue);
                this.parser.canConsume(COMMA_DELIMITER);
                keySchema.merge(key);
                valueSchema.merge(value);
            }
            if (COMMA_DELIMITER.equals(this.parser.previous())) {
                throw new DataException("Map is missing element after ',': " + this.parser.original());
            }
            throw new DataException("Map is missing terminating '}': " + this.parser.original());
        }

        private SchemaAndValue parseMultipleTokensAsTemporal(String token) {
            String timeOrTimestampStr;
            SchemaAndValue temporal;
            int position = this.parser.mark();
            String remainder = this.parser.next(4);
            if (remainder != null && (temporal = ValueParser.parseAsTemporal(timeOrTimestampStr = token + remainder)) != null) {
                return temporal;
            }
            this.parser.rewindTo(position);
            return ValueParser.parseAsTemporal(token);
        }

        private static SchemaAndValue parseAsNumber(String token) {
            BigDecimal decimal = new BigDecimal(token);
            SchemaAndValue exactDecimal = ValueParser.parseAsExactDecimal(decimal);
            float fValue = decimal.floatValue();
            double dValue = decimal.doubleValue();
            if (exactDecimal != null) {
                return exactDecimal;
            }
            if (fValue != Float.NEGATIVE_INFINITY && fValue != Float.POSITIVE_INFINITY && decimal.scale() != 0) {
                return new SchemaAndValue(Schema.FLOAT32_SCHEMA, Float.valueOf(fValue));
            }
            if (dValue != Double.NEGATIVE_INFINITY && dValue != Double.POSITIVE_INFINITY && decimal.scale() != 0) {
                return new SchemaAndValue(Schema.FLOAT64_SCHEMA, dValue);
            }
            Schema schema = Decimal.schema(decimal.scale());
            return new SchemaAndValue(schema, decimal);
        }

        private static SchemaAndValue parseAsExactDecimal(BigDecimal decimal) {
            BigDecimal floor;
            BigDecimal ceil = decimal.setScale(0, RoundingMode.CEILING);
            if (ceil.equals(floor = decimal.setScale(0, RoundingMode.FLOOR))) {
                BigInteger num = ceil.toBigIntegerExact();
                if (ceil.precision() >= 19 && (num.compareTo(LONG_MIN) < 0 || num.compareTo(LONG_MAX) > 0)) {
                    return null;
                }
                long integral = num.longValue();
                byte int8 = (byte)integral;
                short int16 = (short)integral;
                int int32 = (int)integral;
                if ((long)int8 == integral) {
                    return new SchemaAndValue(Schema.INT8_SCHEMA, int8);
                }
                if ((long)int16 == integral) {
                    return new SchemaAndValue(Schema.INT16_SCHEMA, int16);
                }
                if ((long)int32 == integral) {
                    return new SchemaAndValue(Schema.INT32_SCHEMA, int32);
                }
                return new SchemaAndValue(Schema.INT64_SCHEMA, integral);
            }
            return null;
        }

        private static SchemaAndValue parseAsTemporal(String token) {
            if (token == null) {
                return null;
            }
            int tokenLength = (token = token.replace("\\:", ENTRY_DELIMITER)).length();
            if (tokenLength == ISO_8601_TIME_LENGTH) {
                return ValueParser.parseAsTemporalType(token, Time.SCHEMA, Values.ISO_8601_TIME_FORMAT_PATTERN);
            }
            if (tokenLength == ISO_8601_TIMESTAMP_LENGTH) {
                return ValueParser.parseAsTemporalType(token, Timestamp.SCHEMA, Values.ISO_8601_TIMESTAMP_FORMAT_PATTERN);
            }
            if (tokenLength == ISO_8601_DATE_LENGTH) {
                return ValueParser.parseAsTemporalType(token, Date.SCHEMA, Values.ISO_8601_DATE_FORMAT_PATTERN);
            }
            return null;
        }

        private static SchemaAndValue parseAsTemporalType(String token, Schema schema, String pattern) {
            ParsePosition pos = new ParsePosition(0);
            java.util.Date result = new SimpleDateFormat(pattern).parse(token, pos);
            if (pos.getIndex() != 0) {
                return new SchemaAndValue(schema, result);
            }
            return null;
        }
    }

    protected static class Parser {
        private final String original;
        private final CharacterIterator iter;
        private String nextToken = null;
        private String previousToken = null;

        public Parser(String original) {
            this.original = original;
            this.iter = new StringCharacterIterator(this.original);
        }

        public int position() {
            return this.iter.getIndex();
        }

        public int mark() {
            return this.iter.getIndex() - (this.nextToken != null ? this.nextToken.length() : 0);
        }

        public void rewindTo(int position) {
            this.iter.setIndex(position);
            this.nextToken = null;
            this.previousToken = null;
        }

        public String original() {
            return this.original;
        }

        public boolean hasNext() {
            return this.nextToken != null || this.canConsumeNextToken();
        }

        protected boolean canConsumeNextToken() {
            return this.iter.getEndIndex() > this.iter.getIndex();
        }

        public String next() {
            if (this.nextToken != null) {
                this.previousToken = this.nextToken;
                this.nextToken = null;
            } else {
                this.previousToken = this.consumeNextToken();
            }
            return this.previousToken;
        }

        public String next(int n) {
            int current = this.mark();
            int start = this.mark();
            for (int i = 0; i != n; ++i) {
                if (!this.hasNext()) {
                    this.rewindTo(start);
                    return null;
                }
                this.next();
            }
            return this.original.substring(current, this.position());
        }

        private String consumeNextToken() throws NoSuchElementException {
            boolean escaped = false;
            int start = this.iter.getIndex();
            char c = this.iter.current();
            while (this.canConsumeNextToken()) {
                switch (c) {
                    case '\\': {
                        escaped = !escaped;
                        break;
                    }
                    case '\"': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        if (!escaped) {
                            if (start < this.iter.getIndex()) {
                                return this.original.substring(start, this.iter.getIndex());
                            }
                            this.iter.next();
                            return this.original.substring(start, start + 1);
                        }
                        escaped = false;
                        break;
                    }
                    default: {
                        escaped = false;
                    }
                }
                c = this.iter.next();
            }
            return this.original.substring(start, this.iter.getIndex());
        }

        public String previous() {
            return this.previousToken;
        }

        public boolean canConsume(String expected) {
            return this.canConsume(expected, true);
        }

        public boolean canConsume(String expected, boolean ignoreLeadingAndTrailingWhitespace) {
            if (this.isNext(expected, ignoreLeadingAndTrailingWhitespace)) {
                this.nextToken = null;
                return true;
            }
            return false;
        }

        protected boolean isNext(String expected, boolean ignoreLeadingAndTrailingWhitespace) {
            if (this.nextToken == null) {
                if (!this.hasNext()) {
                    return false;
                }
                this.nextToken = this.consumeNextToken();
            }
            if (ignoreLeadingAndTrailingWhitespace) {
                while (Utils.isBlank((String)this.nextToken) && this.canConsumeNextToken()) {
                    this.nextToken = this.consumeNextToken();
                }
            }
            return ignoreLeadingAndTrailingWhitespace ? this.nextToken.trim().equals(expected) : this.nextToken.equals(expected);
        }
    }

    private static class SchemaMerger {
        private Schema common = null;
        private boolean compatible = true;

        private SchemaMerger() {
        }

        protected void merge(SchemaAndValue latest) {
            if (latest != null && latest.schema() != null && this.compatible) {
                if (this.common == null) {
                    this.common = latest.schema();
                } else {
                    this.common = Values.mergeSchemas(this.common, latest.schema());
                    this.compatible = this.common != null;
                }
            }
        }

        protected boolean hasCommonSchema() {
            return this.common != null;
        }

        protected Schema schema() {
            return this.common;
        }
    }
}

