/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableNavigableSet;

public class AclCache {
    private final ImmutableNavigableSet<StandardAcl> aclsByResource;
    private final ImmutableMap<Uuid, StandardAcl> aclsById;

    AclCache() {
        this((ImmutableNavigableSet<StandardAcl>)ImmutableNavigableSet.empty(), (ImmutableMap<Uuid, StandardAcl>)ImmutableMap.empty());
    }

    private AclCache(ImmutableNavigableSet<StandardAcl> aclsByResource, ImmutableMap<Uuid, StandardAcl> aclsById) {
        this.aclsByResource = aclsByResource;
        this.aclsById = aclsById;
    }

    public ImmutableNavigableSet<StandardAcl> aclsByResource() {
        return this.aclsByResource;
    }

    Iterable<AclBinding> acls(AclBindingFilter filter) {
        ArrayList<AclBinding> aclBindingList = new ArrayList<AclBinding>();
        this.aclsByResource.forEach(acl -> {
            AclBinding aclBinding = acl.toBinding();
            if (filter.matches(aclBinding)) {
                aclBindingList.add(aclBinding);
            }
        });
        return aclBindingList;
    }

    int count() {
        return this.aclsById.size();
    }

    StandardAcl getAcl(Uuid id) {
        return (StandardAcl)this.aclsById.get((Object)id);
    }

    AclCache addAcl(Uuid id, StandardAcl acl) {
        StandardAcl prevAcl = (StandardAcl)this.aclsById.get((Object)id);
        if (prevAcl != null) {
            throw new RuntimeException("An ACL with ID " + id + " already exists.");
        }
        ImmutableMap aclsById = this.aclsById.updated((Object)id, (Object)acl);
        if (this.aclsByResource.contains((Object)acl)) {
            throw new RuntimeException("Unable to add the ACL with ID " + id + " to aclsByResource");
        }
        ImmutableNavigableSet aclsByResource = this.aclsByResource.added((Object)acl);
        return new AclCache((ImmutableNavigableSet<StandardAcl>)aclsByResource, (ImmutableMap<Uuid, StandardAcl>)aclsById);
    }

    AclCache removeAcl(Uuid id) {
        StandardAcl acl = (StandardAcl)this.aclsById.get((Object)id);
        if (acl == null) {
            throw new RuntimeException("ID " + id + " not found in aclsById.");
        }
        ImmutableMap aclsById = this.aclsById.removed((Object)id);
        if (!this.aclsByResource.contains((Object)acl)) {
            throw new RuntimeException("Unable to remove the ACL with ID " + id + " from aclsByResource");
        }
        ImmutableNavigableSet aclsByResource = this.aclsByResource.removed((Object)acl);
        return new AclCache((ImmutableNavigableSet<StandardAcl>)aclsByResource, (ImmutableMap<Uuid, StandardAcl>)aclsById);
    }
}

