/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class SnapshotEmitterMetrics
implements AutoCloseable {
    private static final MetricName LATEST_SNAPSHOT_GENERATED_BYTES = SnapshotEmitterMetrics.getMetricName("SnapshotEmitter", "LatestSnapshotGeneratedBytes");
    private static final MetricName LATEST_SNAPSHOT_GENERATED_AGE_MS = SnapshotEmitterMetrics.getMetricName("SnapshotEmitter", "LatestSnapshotGeneratedAgeMs");
    private final Optional<MetricsRegistry> registry;
    private final Time time;
    private final AtomicLong latestSnapshotGeneratedBytes;
    private final AtomicLong latestSnapshotGeneratedTimeMs;

    public SnapshotEmitterMetrics(Optional<MetricsRegistry> registry, Time time) {
        this.registry = registry;
        this.time = time;
        this.latestSnapshotGeneratedBytes = new AtomicLong(0L);
        this.latestSnapshotGeneratedTimeMs = new AtomicLong(time.milliseconds());
        registry.ifPresent(r -> r.newGauge(LATEST_SNAPSHOT_GENERATED_BYTES, (Gauge)new Gauge<Long>(){

            public Long value() {
                return SnapshotEmitterMetrics.this.latestSnapshotGeneratedBytes();
            }
        }));
        registry.ifPresent(r -> r.newGauge(LATEST_SNAPSHOT_GENERATED_AGE_MS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return SnapshotEmitterMetrics.this.latestSnapshotGeneratedAgeMs();
            }
        }));
    }

    public void setLatestSnapshotGeneratedBytes(long value) {
        this.latestSnapshotGeneratedBytes.set(value);
    }

    public long latestSnapshotGeneratedBytes() {
        return this.latestSnapshotGeneratedBytes.get();
    }

    public void setLatestSnapshotGeneratedTimeMs(long timeMs) {
        this.latestSnapshotGeneratedTimeMs.set(timeMs);
    }

    public long latestSnapshotGeneratedTimeMs() {
        return this.latestSnapshotGeneratedTimeMs.get();
    }

    public long latestSnapshotGeneratedAgeMs() {
        return this.time.milliseconds() - this.latestSnapshotGeneratedTimeMs.get();
    }

    @Override
    public void close() {
        this.registry.ifPresent(r -> Arrays.asList(LATEST_SNAPSHOT_GENERATED_BYTES, LATEST_SNAPSHOT_GENERATED_AGE_MS).forEach(arg_0 -> ((MetricsRegistry)r).removeMetric(arg_0)));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)type, (String)name);
    }
}

