/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class Bond
extends Edge {
    public static final int myVisibilityFlag = JC.getShapeVisibilityFlag(1);
    public Atom atom1;
    public Atom atom2;
    public short mad;
    public short colix;
    public int shapeVisibilityFlags;

    public Bond(Atom atom1, Atom atom2, int order, short mad, short colix) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.colix = colix;
        this.setOrder(order);
        this.setMad(mad);
    }

    public void setMad(short mad) {
        this.mad = mad;
        this.setShapeVisibility(mad != 0);
    }

    void setShapeVisibility(boolean isVisible) {
        boolean wasVisible;
        boolean bl = wasVisible = (this.shapeVisibilityFlags & myVisibilityFlag) != 0;
        if (wasVisible == isVisible) {
            return;
        }
        this.atom1.addDisplayedBond(myVisibilityFlag, isVisible);
        this.atom2.addDisplayedBond(myVisibilityFlag, isVisible);
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= myVisibilityFlag) : (this.shapeVisibilityFlags &= ~myVisibilityFlag);
    }

    public String getIdentity() {
        return this.index + 1 + " " + Edge.getBondOrderNumberFromOrder(this.order) + " " + this.atom1.getInfo() + " -- " + this.atom2.getInfo() + " " + this.atom1.distance(this.atom2);
    }

    @Override
    public boolean isCovalent() {
        return (this.order & 0x3FF) != 0;
    }

    @Override
    public boolean isHydrogen() {
        return Bond.isOrderH(this.order);
    }

    public boolean isAromatic() {
        return (this.order & 0x200) != 0;
    }

    public float getEnergy() {
        return 0.0f;
    }

    public int getValence() {
        return !this.isCovalent() || this.order == 33 ? 0 : (this.is(515) ? 1 : this.order & 7);
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setTranslucent(boolean isTranslucent, float translucentLevel) {
        this.colix = C.getColixTranslucent3(this.colix, isTranslucent, translucentLevel);
    }

    public void setOrder(int order) {
        if (this.atom1.getElementNumber() == 16 && this.atom2.getElementNumber() == 16) {
            order |= 0x100;
        }
        if (order == 512) {
            order = 515;
        }
        this.order = order | this.order & 0x20000;
    }

    @Override
    public int getAtomIndex1() {
        return this.atom1.i;
    }

    @Override
    public int getAtomIndex2() {
        return this.atom2.i;
    }

    @Override
    public int getCovalentOrder() {
        return Edge.getCovalentBondOrder(this.order);
    }

    public Atom getOtherAtom(Atom thisAtom) {
        return this.atom1 == thisAtom ? this.atom2 : (this.atom2 == thisAtom ? this.atom1 : null);
    }

    public boolean is(int bondType) {
        return (this.order & 0x1FFFF) == bondType;
    }

    @Override
    public SimpleNode getOtherNode(SimpleNode thisAtom) {
        return this.atom1 == thisAtom ? this.atom2 : (this.atom2 == thisAtom || thisAtom == null ? this.atom1 : null);
    }

    public void setAtropisomerOptions() {
        Atom a;
        int i1;
        int i2 = Integer.MAX_VALUE;
        Bond[] bonds = this.atom1.bonds;
        for (i1 = 0; i1 < bonds.length && (a = bonds[i1].getOtherAtom(this.atom1)) == this.atom2; ++i1) {
        }
        if (i1 < bonds.length) {
            bonds = this.atom2.bonds;
            for (i2 = 0; i2 < bonds.length && (a = bonds[i2].getOtherAtom(this.atom2)) == this.atom1; ++i2) {
            }
        }
        this.order = i1 > 2 || i2 >= bonds.length || i2 > 2 ? 1 : Bond.getAtropismOrder(i1 + 1, i2 + 1);
    }

    @Override
    public String getCIPChirality(boolean doCalculate) {
        return "";
    }

    @Override
    public void setCIPChirality(int c) {
    }

    public String toString() {
        return this.atom1 + " - " + this.atom2;
    }

    @Override
    public SimpleNode getAtom(int i) {
        return i == 1 ? this.atom2 : this.atom1;
    }

    public boolean isCovalentNotPartial0() {
        return (this.order & 0x3FF) != 0 && this.order != 33;
    }
}

