#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-GbFfnr86BH5JHu1X2hPB5X
key:                  idris-1.3.4-GbFfnr86BH5JHu1X2hPB5X
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  a2d24259b33d796cb72733a3426128a7
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.2.8/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-GbFfnr86BH5JHu1X2hPB5X
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    annotated-wl-pprint-0.7.0-JJ8k3Us8XMDCld6qYY6FFz
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE
    ansi-wl-pprint-0.6.9-9ctTtDT9IMdHR9rtwZQvOW array-0.5.4.0
    async-2.2.5-LvPNzfas2yXKoPkwBBcN3R base-4.16.4.0
    base64-bytestring-1.2.1.0-74HkITi20nv2BdJvE3AKcV binary-0.8.9.0
    blaze-html-0.9.2.0-ARMUh31ndZFLabXVs8gk0N
    blaze-markup-0.8.3.0-HRiNog23ingBf0HHxn7tF0 bytestring-0.11.4.0
    cheapskate-0.1.1.2-HmzkaUBCFVv5fNwbngOwn7
    code-page-0.2.1-2Ge3Prwpi0K5qObDyqbdK0 containers-0.6.5.1
    deepseq-1.4.6.1 directory-1.3.6.2 filepath-1.4.2.2
    fingertree-0.1.5.0-Dwb2xzQagZ447GFqvLu1lo
    fsnotify-0.4.1.0-2IPizNBAl1t14YyuLeiiet haskeline-0.8.2
    ieee754-0.8.0-jBSJf9r7fS9cohIIWFx2y
    libffi-0.2.1-LccIAuoU8yrBMDFxV9AXvd
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5 pretty-1.1.3.6
    process-1.6.16.0 regex-tdfa-1.3.2.2-9zKmqEaVx0vIf4YwE2VWyu
    safe-0.3.21-JdttgF4acvJfVRaNLAh split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh
    terminal-size-0.3.4-7GJNKkuDjwr8c9rYP2Bu9E text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2
    uniplate-1.6.13-AjSqydB1rb24oLC5xoUisy unix-2.7.2.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    vector-binary-instances-0.2.5.2-LOgfeWhwoHGKiAb2EnUKPN
    zip-archive-0.4.3.2-JoEJDrgiwOE77pKRvuA2GN

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

