#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-EVXUuSdHO8m6U6HXrsiuNH
key:                  hledger-web-1.32.1-EVXUuSdHO8m6U6HXrsiuNH
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  fa51e9ae85fdb4ec2bf4422ac1c68842
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-EVXUuSdHO8m6U6HXrsiuNH
depends:
    Decimal-0.5.2-70fk5A4GyK41cq8fiRy7Ag
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6 base-4.16.4.0
    base64-0.4.2.4-EkDZow7G1kYB6iU95hHX2k
    blaze-html-0.9.2.0-ARMUh31ndZFLabXVs8gk0N
    blaze-markup-0.8.3.0-HRiNog23ingBf0HHxn7tF0 bytestring-0.11.4.0
    case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    clientsession-0.9.2.0-LlDtYb5sXRW5JdpfQqKBS3
    cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    conduit-1.3.6-GKnHuzD4Nn6IarMahEfIxq
    conduit-extra-1.3.6-DF8DOiU714JCf1u0kSL4TS containers-0.6.5.1
    data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS directory-1.3.6.2
    extra-1.7.16-KR1Y4egVNjKBcN1wDcWpKS filepath-1.4.2.2
    hjsmin-0.2.0.4-C1VJLe68GpmH4EaC4kjRQl
    hledger-1.32.1-73T5dRbHqsG2xKFfOQbrQ1
    hledger-lib-1.32.1-DtJjaCw1EFU66ZSlQHkur4
    hspec-2.10.9-7Qty0hg4HEN3rGne27aCg9
    http-client-0.7.17-JgdZSxk89UYJjfjCxx3dTH
    http-conduit-2.3.9.1-FNv0ePe3csxJhmoIauZC0T
    http-types-0.12.4-G97153ZIeGq6X7uXEs2l2V
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt mtl-2.2.2
    network-3.1.4.0-I7hY9PROidqFfCvyq23hqh
    safe-0.3.21-JdttgF4acvJfVRaNLAh
    shakespeare-2.1.0.1-Cj2ORqpW9VZ9CRwQUx0JNp
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-compat-0.7.2-9EkyOdRG6Oq7mRyWipBzHf
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX
    wai-3.2.4-BNQtAxBTTmbBe7Crr2a2xg
    wai-cors-0.2.7-GSUk0zM1b7sFtug1c4yYgT
    wai-extra-3.1.15-9pU0z7iIsCu8vLAVmw1tBo
    wai-handler-launch-3.0.3.1-KCxo4a15HEDKjG70GjyqyY
    warp-3.3.30-JQuxlSSi13uLhX74fYOoJn
    yaml-0.11.11.2-9MxOzRHsMDt4HQwRFFgCZL
    yesod-1.6.2.1-2lIeO7aUin2CjMKuBWILEP
    yesod-core-1.6.26.0-1CMGLMJfPVt36CzR4vPKLc
    yesod-form-1.7.6-6XdKGqURDSB74whB3tKXNR
    yesod-static-1.6.1.0-BBiBqVarfgQA6rGa0O9XDB
    yesod-test-1.6.16-KcGm99w5u9mCJx6uhyfwnk

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

