#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-iadd
version:              1.3.20
visibility:           public
id:                   hledger-iadd-1.3.20-C3tSn4IteDT3sF9Szr3XQ7
key:                  hledger-iadd-1.3.20-C3tSn4IteDT3sF9Szr3XQ7
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  fd86eeb0ec70b1ca949c62561a5a55f1
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-iadd-1.3.20
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-iadd-1.3.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.20-C3tSn4IteDT3sF9Szr3XQ7
depends:
    base-4.16.4.0 brick-1.7-8rMNrRoWuq0BiWrf5nzVbr containers-0.6.5.1
    directory-1.3.6.2 free-5.1.10-JdZwDRCoHyGAIQAex9ij2v
    hledger-lib-1.32.1-DtJjaCw1EFU66ZSlQHkur4
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-mtl-0.2.0.3-K2j2D46quth4CyQpetHsMp
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb text-1.2.5.0
    text-zipper-0.13-K8U9UU22RJ5GMcc8Glpqyj time-1.11.1.1
    transformers-0.5.6.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    vty-5.39-7gJNXoTzFFy85rvoBR06CX
    xdg-basedir-0.2.2-BAENMrhgj9o4xkjbLJyx83

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

