#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger
version:              1.32.1
visibility:           public
id:                   hledger-1.32.1-73T5dRbHqsG2xKFfOQbrQ1
key:                  hledger-1.32.1-73T5dRbHqsG2xKFfOQbrQ1
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  b79526c96f1512b979a7616f709aea41
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.32.1-73T5dRbHqsG2xKFfOQbrQ1
depends:
    Decimal-0.5.2-70fk5A4GyK41cq8fiRy7Ag
    Diff-0.4.1-47RlfWGWXds34vUy9hSQS
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE base-4.16.4.0
    bytestring-0.11.4.0 cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    containers-0.6.5.1 data-default-0.7.1.1-KHhiQ7RPZneCNDFTFmFAYS
    directory-1.3.6.2 extra-1.7.16-KR1Y4egVNjKBcN1wDcWpKS
    filepath-1.4.2.2 githash-0.1.6.3-KXrhUonS8sTItduZ1hbP4e
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3 haskeline-0.8.2
    hledger-lib-1.32.1-DtJjaCw1EFU66ZSlQHkur4
    lucid-2.11.20230408-2XJfoZnsUwvIVfQTYQrLXo
    math-functions-0.3.4.4-4t3X6AVXtzGCUa2A4nrWTl
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA mtl-2.2.2
    process-1.6.16.0 regex-tdfa-1.3.2.2-9zKmqEaVx0vIf4YwE2VWyu
    safe-0.3.21-JdttgF4acvJfVRaNLAh
    shakespeare-2.1.0.1-Cj2ORqpW9VZ9CRwQUx0JNp
    split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh
    tabular-0.2.2.8-95p3h1QIWwyCocci2BuF7w
    tasty-1.4.3-2gR9WDhWbJHGLAofnQHAx7
    temporary-1.3-FDskYhMei4uKi1JCFLXz31 terminfo-0.4.1.5 text-1.2.5.0
    text-ansi-0.2.1.1-1aEWUie07q4LkbcgGvXCeL time-1.11.1.1
    timeit-2.0-FPerWVMxZElJkpHtTsXEJ4 transformers-0.5.6.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX
    utility-ht-0.0.17.2-DJSGjXLHOJo8uHrZTx8IpQ
    wizards-1.0.3-614DR2XTBGc2LfYMK8q7fT

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

