#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wreq
version:              0.5.4.3
visibility:           public
id:                   wreq-0.5.4.3-3um9krjvtDE4dCf3UfXTxl
key:                  wreq-0.5.4.3-3um9krjvtDE4dCf3UfXTxl
license:              BSD-3-Clause
copyright:            2014 Bryan O'\''Sullivan
maintainer:           bos@serpentine.com
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             http://www.serpentine.com/wreq
synopsis:             An easy-to-use HTTP client library.
description:
    .
    A web client library that is designed for ease of use.
    .
    Tutorial: <http://www.serpentine.com/wreq/tutorial.html>
    .
    Features include:
    .
    * Simple but powerful `lens`-based API
    .
    * A solid test suite, and built on reliable libraries like
      http-client and lens
    .
    * Session handling includes connection keep-alive and pooling, and
      cookie persistence
    .
    * Automatic response body decompression
    .
    * Powerful multipart form and file upload handling
    .
    * Support for JSON requests and responses, including navigation of
      schema-less responses
    .
    * Basic and OAuth2 bearer authentication
    .
    * Early TLS support via the tls package

category:             Web
abi:                  7800dfd982e338629ee92ded2b38ff59
exposed:              True
exposed-modules:
    Network.Wreq Network.Wreq.Cache Network.Wreq.Cache.Store
    Network.Wreq.Lens Network.Wreq.Session Network.Wreq.Types

hidden-modules:
    Network.Wreq.Internal Network.Wreq.Internal.AWS
    Network.Wreq.Internal.Lens Network.Wreq.Internal.Link
    Network.Wreq.Internal.OAuth1 Network.Wreq.Internal.Types
    Network.Wreq.Lens.Machinery Network.Wreq.Lens.TH Paths_wreq

import-dirs:          /usr/lib/ghc-9.2.8/site-local/wreq-0.5.4.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/wreq-0.5.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wreq
hs-libraries:         HSwreq-0.5.4.3-3um9krjvtDE4dCf3UfXTxl
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB
    authenticate-oauth-1.7-6qKShKwIvqo5S8sSkMMBKy base-4.16.4.0
    base16-bytestring-1.0.2.0-E91HY5tPsI5AcRTlaN47xj
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-C9u4G83SV6G4MBj88LrUbo
    containers-0.6.5.1 crypton-0.34-54lgSIlR3HB8xQcOPeFemb
    exceptions-0.10.4 ghc-prim-0.8.0
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    http-client-0.7.17-JgdZSxk89UYJjfjCxx3dTH
    http-client-tls-0.3.6.3-9tLQnIY72wX7jTuvJ6seUd
    http-types-0.12.4-G97153ZIeGq6X7uXEs2l2V
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    lens-aeson-1.2.3-BBphJVjNPgEDcmhk2pQ1eR
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    mime-types-0.1.2.0-4X5b6Sz1aAM6TugVqfWYtQ
    psqueues-0.2.8.0-GPIa45uYdzqL9nP2axtGMr template-haskell-2.18.0.0
    text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn

haddock-interfaces:   /usr/share/doc/haskell-wreq/html/wreq.haddock
haddock-html:         /usr/share/doc/haskell-wreq/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

