#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 what4
version:              1.5.1
visibility:           public
id:                   what4-1.5.1-7T0dYKTD7y31BPX3Bs2R0z
key:                  what4-1.5.1-7T0dYKTD7y31BPX3Bs2R0z
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2023
maintainer:           rscott@galois.com, kquick@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, CVC5, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  ab50692af02991c5c24abd9b50ad088d
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Serialize.FastSExpr
    What4.Serialize.Log What4.Serialize.Normalize
    What4.Serialize.Parser What4.Serialize.Printer
    What4.Serialize.SETokens What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.CVC5
    What4.Solver.DReal What4.Solver.ExternalABC What4.Solver.STP
    What4.Solver.Yices What4.Solver.Z3 What4.SpecialFunctions
    What4.Symbol What4.Utils.AbstractDomains What4.Utils.AnnotatedMap
    What4.Utils.Arithmetic What4.Utils.BVDomain
    What4.Utils.BVDomain.Arith What4.Utils.BVDomain.Bitwise
    What4.Utils.BVDomain.XOR What4.Utils.Complex What4.Utils.Endian
    What4.Utils.Environment What4.Utils.FloatHelpers
    What4.Utils.HandleReader What4.Utils.IncrHash What4.Utils.LeqMap
    What4.Utils.MonadST What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Serialize
    What4.Utils.Streams What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.2.8/site-local/what4-1.5.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/what4-1.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.5.1-7T0dYKTD7y31BPX3Bs2R0z
depends:
    BoundedChan-1.0.3.0-GASw0jI0hsI8wIs0B8SAkA
    async-2.2.5-LvPNzfas2yXKoPkwBBcN3R
    attoparsec-0.14.4-DN7s9Fr9c113K5agmmE0LB base-4.16.4.0
    bifunctors-5.6-24PtXDCU2m5EbKOhSIeuUk
    bimap-0.5.0-Lff8yM2m6Ue1rQYSNZ54vi
    bv-sized-1.0.5-8exTuOpLBxp5Y1lGDbecGB bytestring-0.11.4.0
    concurrent-extra-0.7.0.12-G6GJXVLrUJHKkbjcrGzNc3
    config-value-0.8.3-8yCRuGm4wH18pEPQuVa8HA containers-0.6.5.1
    deepseq-1.4.6.1 deriving-compat-0.6.6-AvxwrARdaeO99MTFB6uOrZ
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.2
    fingertree-0.1.5.0-Dwb2xzQagZ447GFqvLu1lo ghc-prim-0.8.0
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    hashtables-1.3.1-BIGErjGkUsKDIV8OglkNSk
    io-streams-1.5.2.2-D3kNbL7qUGO6OCiY4i9LSN
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp
    libBF-0.6.5.1-3mfje13GZOR4tMl2GcE9d6
    megaparsec-9.6.1-7WPy93vP8bY6Hp5k3jEfIt mtl-2.2.2
    ordered-containers-0.2.4-1JlMtwpl5aGFUmpQniEPVA
    panic-0.4.0.1-HPbW5wuhX2x4TYrkc6yjYz
    parameterized-utils-2.1.9.0-9s1fvxLn86XDqeZKgFxfPx parsec-3.1.15.0
    prettyprinter-1.7.1-JEDC7ONR1vQJETgOTWpLZ0 process-1.6.16.0
    s-cargot-0.1.6.0-C93sPFez20t3DfF2ROeCvd
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa stm-2.5.0.2
    template-haskell-2.18.0.0 temporary-1.3-FDskYhMei4uKi1JCFLXz31
    text-1.2.5.0 th-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
    th-lift-instances-0.1.20-IADkcbonWiw49hgUprRlYc time-1.11.1.1
    transformers-0.5.6.2 unliftio-0.2.25.0-I5KL8dbXVmE3dWILMxzDhI
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ
    versions-6.0.4-IwlXaRGjDjcCwhT5CqKlHK
    zenc-0.1.2-BJ0i8zZGVOFzNrXfX0ZRX

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

