#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vty
version:              5.39
visibility:           public
id:                   vty-5.39-7gJNXoTzFFy85rvoBR06CX
key:                  vty-5.39-7gJNXoTzFFy85rvoBR06CX
license:              BSD-3-Clause
maintainer:           Jonathan Daugherty (cygnus@foobox.com)
author:               AUTHORS
homepage:             https://github.com/jtdaugherty/vty
synopsis:             A simple terminal UI library
description:
    vty is terminal GUI library in the niche of ncurses. It is intended to
    be easy to use and to provide good support for common terminal types.

    See the @vty-examples@ package as well as the program
    @examples/interactive_terminal_test.hs@ included in the @vty@
    repository for examples on how to use the library.

    Import the @Graphics.Vty@ convenience module to get access to the core
    parts of the library.

    &#169; 2006-2007 Stefan O'\''Rear; BSD3 license.

    &#169; Corey O'\''Connor; BSD3 license.

    &#169; Jonathan Daugherty; BSD3 license.

category:             User Interfaces
abi:                  3f0e7457d101dc70d72c5bfef7d85f56
exposed:              True
exposed-modules:
    Data.Terminfo.Eval Data.Terminfo.Parse Graphics.Text.Width
    Graphics.Vty Graphics.Vty.Attributes Graphics.Vty.Attributes.Color
    Graphics.Vty.Attributes.Color240 Graphics.Vty.Config
    Graphics.Vty.Debug Graphics.Vty.DisplayAttributes
    Graphics.Vty.Error Graphics.Vty.Image Graphics.Vty.Image.Internal
    Graphics.Vty.Inline Graphics.Vty.Inline.Unsafe Graphics.Vty.Input
    Graphics.Vty.Input.Classify Graphics.Vty.Input.Classify.Parse
    Graphics.Vty.Input.Classify.Types Graphics.Vty.Input.Events
    Graphics.Vty.Input.Focus Graphics.Vty.Input.Loop
    Graphics.Vty.Input.Mouse Graphics.Vty.Input.Paste
    Graphics.Vty.Input.Terminfo Graphics.Vty.Output
    Graphics.Vty.Output.Interface Graphics.Vty.Output.Mock
    Graphics.Vty.Output.TerminfoBased Graphics.Vty.Output.XTermColor
    Graphics.Vty.Picture Graphics.Vty.PictureToSpans Graphics.Vty.Span
    Graphics.Vty.UnicodeWidthTable.IO
    Graphics.Vty.UnicodeWidthTable.Install
    Graphics.Vty.UnicodeWidthTable.Query
    Graphics.Vty.UnicodeWidthTable.Types

hidden-modules:       Graphics.Vty.Input.Terminfo.ANSIVT
import-dirs:          /usr/lib/ghc-9.2.8/site-local/vty-5.39
library-dirs:         /usr/lib/ghc-9.2.8/site-local/vty-5.39
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vty5
hs-libraries:         HSvty-5.39-7gJNXoTzFFy85rvoBR06CX
depends:
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE base-4.16.4.0
    binary-0.8.9.0 blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK
    bytestring-0.11.4.0 containers-0.6.5.1 deepseq-1.4.6.1
    directory-1.3.6.2 filepath-1.4.2.2
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-mtl-0.2.0.3-K2j2D46quth4CyQpetHsMp
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6 mtl-2.2.2
    parsec-3.1.15.0 stm-2.5.0.2 terminfo-0.4.1.5 text-1.2.5.0
    transformers-0.5.6.2 unix-2.7.2.2
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-vty5/html/vty.haddock
haddock-html:         /usr/share/doc/haskell-vty5/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

