#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 uuid-types
version:              1.0.5.1
visibility:           public
id:                   uuid-types-1.0.5.1-J2sbKAR6gu99vJPWCEy8Jh
key:                  uuid-types-1.0.5.1-J2sbKAR6gu99vJPWCEy8Jh
license:              BSD-3-Clause
copyright:
    (c) 2017-2018 Herbert Valerio Riedel
    (c) 2008-2014 Antoine Latter

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:             Type definitions for Universally Unique Identifiers
description:
    This library contains type definitions for
    <https://en.wikipedia.org/wiki/UUID Universally Unique Identifiers (UUID)>
    (as specified in
    <http://tools.ietf.org/html/rfc4122 RFC 4122>)
    and basic conversion functions.

    See also the <https://hackage.haskell.org/package/uuid '\''uuid'\'' package>
    providing a high-level API for managing the different UUID versions.

category:             Data
abi:                  e028e6f03242cd52a218a58eb5c1a180
exposed:              True
exposed-modules:
    Data.UUID.Types Data.UUID.Types.Internal
    Data.UUID.Types.Internal.Builder

import-dirs:          /usr/lib/ghc-9.2.8/site-local/uuid-types-1.0.5.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/uuid-types-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid-types
hs-libraries:         HSuuid-types-1.0.5.1-J2sbKAR6gu99vJPWCEy8Jh
depends:
    base-4.16.4.0 binary-0.8.9.0 bytestring-0.11.4.0 deepseq-1.4.6.1
    hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    random-1.2.1.2-3aSfWlsu7xc3wK3TRJn2vY template-haskell-2.18.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-uuid-types/html/uuid-types.haddock
haddock-html:         /usr/share/doc/haskell-uuid-types/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

