#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 universe-reverse-instances
version:              1.1.2
visibility:           public
id:                   universe-reverse-instances-1.1.2-IF3Nng6ht4F6DjOtcqDmrD
key:                  universe-reverse-instances-1.1.2-IF3Nng6ht4F6DjOtcqDmrD
license:              BSD-3-Clause
copyright:            Daniel Wagner 2014
maintainer:           me@dmwit.com
author:               Daniel Wagner
homepage:             https://github.com/dmwit/universe
synopsis:
    Instances of standard classes that are made possible by enumerations

description:
    For example this package provides a @Eq (a -> b)@ instance:

    @
    instance (Finite a, Eq b) => Eq (a -> b) where
    f == g = and [f x == g x | x <- universeF]
    @

category:             Data
abi:                  38f1a93af44b89b679ef77a89aeb2e02
exposed:              True
exposed-modules:
    Data.Universe.Instances.Eq Data.Universe.Instances.Ord
    Data.Universe.Instances.Read Data.Universe.Instances.Show
    Data.Universe.Instances.Traversable

import-dirs:
    /usr/lib/ghc-9.2.8/site-local/universe-reverse-instances-1.1.2

library-dirs:
    /usr/lib/ghc-9.2.8/site-local/universe-reverse-instances-1.1.2

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-universe-reverse-instances
hs-libraries:         HSuniverse-reverse-instances-1.1.2-IF3Nng6ht4F6DjOtcqDmrD
depends:
    base-4.16.4.0 containers-0.6.5.1
    universe-base-1.1.4-4vNj5MbIHT1BPBcTU09g9c

haddock-interfaces:
    /usr/share/doc/haskell-universe-reverse-instances/html/universe-reverse-instances.haddock

haddock-html:         /usr/share/doc/haskell-universe-reverse-instances/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

