#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tzdata
version:              0.2.20240201.0
visibility:           public
id:                   tzdata-0.2.20240201.0-CzeOhCl8IMY2waWhsYmJWa
key:                  tzdata-0.2.20240201.0-CzeOhCl8IMY2waWhsYmJWa
license:              Apache-2.0
maintainer:           Janus Troelsen <ysangkok@gmail.com>
author:               Mihaly Barasz, Gergely Risko
stability:            experimental
homepage:             https://github.com/ysangkok/haskell-tzdata
synopsis:             Time zone database (as files and as a module)
description:
    The goal of this package is to distribute the standard Time Zone
    Database in a cabal package, so that it can be used in Haskell
    programs uniformly on all platforms.

    This package currently ships the @2024a@ version of the time zone
    database.  The version of the time zone database shipped is always
    reflected in the version of this package: @x.y.YYYYMMDD.z@, then
    @YYYYMMDD@ is the official release date of time zone database.

    This version contains the "fat" variant of the time zone files (which is not
    the default for the upstream since @2020b@) to facilitate the transition. The
    next major version (@0.3@) will ship the "slim" variant.

    See: <http://www.iana.org/time-zones> for more info about the time
    zone database.

    See also the @tz@ package <http://hackage.haskell.org/package/tz> or
    the @timezone-olson@ and @timezone-series@ packages that provide
    facilities to /use/ the data shipped here. (The @tz@ package
    automatically installs this package.)

category:             Data
abi:                  19499a98a5e66edef2000df42a33d653
exposed:              True
exposed-modules:      Data.Time.Zones.DB Data.Time.Zones.Files
hidden-modules:       Paths_tzdata
import-dirs:          /usr/lib/ghc-9.2.8/site-local/tzdata-0.2.20240201.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tzdata-0.2.20240201.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tzdata
hs-libraries:         HStzdata-0.2.20240201.0-CzeOhCl8IMY2waWhsYmJWa
depends:
    base-4.16.4.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-tzdata/html/tzdata.haddock
haddock-html:         /usr/share/doc/haskell-tzdata/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

