#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 turtle
version:              1.6.2
visibility:           public
id:                   turtle-1.6.2-FA7n5EQ0GjE1rBvNCR7qQs
key:                  turtle-1.6.2-FA7n5EQ0GjE1rBvNCR7qQs
license:              BSD-3-Clause
copyright:            2015 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  f68b721460a1ad28cc407727e1885df1
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/turtle-1.6.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/turtle-1.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-turtle
hs-libraries:         HSturtle-1.6.2-FA7n5EQ0GjE1rBvNCR7qQs
depends:
    ansi-wl-pprint-0.6.9-9ctTtDT9IMdHR9rtwZQvOW
    async-2.2.5-LvPNzfas2yXKoPkwBBcN3R base-4.16.4.0
    bytestring-0.11.4.0 clock-0.8.4-Kzh7X2kPtrQ91MTkkNH1hr
    containers-0.6.5.1 directory-1.3.6.2 exceptions-0.10.4
    filepath-1.4.2.2 foldl-1.4.17-4fUbN0xda6tJYiB38eUblJ
    hostname-1.0-7J3r6zYiFrqIUVPbgMuhYv
    managed-1.0.10-L0mohGNFmrILG4eO9HBKee
    optional-args-1.0.2-FJNsOp6x5DVGExHd6YeVvG
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb
    process-1.6.16.0 stm-2.5.0.2
    streaming-commons-0.2.2.6-AVoXkk31N7L5TjFKruipFD
    temporary-1.3-FDskYhMei4uKi1JCFLXz31 text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.7.2-9EkyOdRG6Oq7mRyWipBzHf

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

