#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-Ca0EA1XqbCbLjQjUpRXO7V
key:                  trifecta-2.1.4-Ca0EA1XqbCbLjQjUpRXO7V
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  97c3c02da6d58cd5d93a3dff2fd4b57e
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.2.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-Ca0EA1XqbCbLjQjUpRXO7V
depends:
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE array-0.5.4.0
    base-4.16.4.0 blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK
    blaze-html-0.9.2.0-ARMUh31ndZFLabXVs8gk0N
    blaze-markup-0.8.3.0-HRiNog23ingBf0HHxn7tF0 bytestring-0.11.4.0
    charset-0.3.11-HGfj9dRdJueDvh0gpZhntT
    comonad-5.0.8-7SvbYtos92D1jPcdvHdUhM containers-0.6.5.1
    deepseq-1.4.6.1 fingertree-0.1.5.0-Dwb2xzQagZ447GFqvLu1lo
    ghc-prim-0.8.0 hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    indexed-traversable-0.1.4-6wPCwLr0dTz5YsFQcHKUoV
    lens-5.2.3-44yRBOAfB7iFMS16KrPjpp mtl-2.2.2
    parsers-0.12.11-4w44w2Sx6nXCRdG7Ne8XkK
    prettyprinter-1.7.1-JEDC7ONR1vQJETgOTWpLZ0
    prettyprinter-ansi-terminal-1.1.3-4WG0PclEa1OHeT9lxo6Wrk
    profunctors-5.6.2-JxKh47DfsCg3BC80FZ7Vhy
    reducers-3.12.4-g2Vi5BnEBd1fZXMCTMp4C transformers-0.5.6.2
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    utf8-string-1.0.2-AQMRv3gsvE14uh4nlO1egX

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

