#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-1NO2gGPB29JEy6bOJa9uuJ
key:                  tree-diff-0.3.0.1-1NO2gGPB29JEy6bOJa9uuJ
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  b9a7371e3006b037c44e378b75ce4809
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-1NO2gGPB29JEy6bOJa9uuJ
depends:
    QuickCheck-2.14.3-5Q3LTiKAdB0LFKfPwDt7Ga
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE
    ansi-wl-pprint-0.6.9-9ctTtDT9IMdHR9rtwZQvOW base-4.16.4.0
    base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd bytestring-0.11.4.0
    containers-0.6.5.1 data-array-byte-0.1.0.1-3S0kBYg95pu3KTMh6Qystd
    deepseq-1.4.6.1 hashable-1.4.4.0-BrYG523VafVKM4yDK0K7G3
    parsec-3.1.15.0 parsers-0.12.11-4w44w2Sx6nXCRdG7Ne8XkK
    pretty-1.1.3.6 primitive-0.7.4.0-I9XTAmFqErC1hXdXvvNzkS
    scientific-0.3.7.0-7nXcZobZD337Jkf1NR7gHa
    semialign-1.2.0.1-FwAdcScZlCCAOTpXC8sBnb
    strict-0.4.0.1-8lBzBTysaJf7j59NPrtuU7
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg text-1.2.5.0
    these-1.1.1.1-IjaKzDKQUlV4D72LRxTl4W time-1.11.1.1
    unordered-containers-0.2.20-HYi8F0R2X5DJGcgMLraHLn
    uuid-types-1.0.5.1-J2sbKAR6gu99vJPWCEy8Jh
    vector-0.13.1.0-Gf2urNiIAD32gZDiWE6SSZ

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

