#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tasty
version:              1.4.3
visibility:           public
id:                   tasty-1.4.3-2gR9WDhWbJHGLAofnQHAx7
key:                  tasty-1.4.3-2gR9WDhWbJHGLAofnQHAx7
license:              MIT
maintainer:           Roman Cheplyaka <roma@ro-che.info>
author:               Roman Cheplyaka <roma@ro-che.info>
homepage:             https://github.com/UnkindPartition/tasty
synopsis:             Modern and extensible testing framework
description:
    Tasty is a modern testing framework for Haskell.
    It lets you combine your unit tests, golden
    tests, QuickCheck/SmallCheck properties, and any
    other types of tests into a single test suite.

category:             Testing
abi:                  421f90663bd48edf3121277399456173
exposed:              True
exposed-modules:
    Test.Tasty Test.Tasty.Ingredients Test.Tasty.Ingredients.Basic
    Test.Tasty.Ingredients.ConsoleReporter Test.Tasty.Options
    Test.Tasty.Patterns.Eval Test.Tasty.Patterns.Parser
    Test.Tasty.Patterns.Printer Test.Tasty.Patterns.Types
    Test.Tasty.Providers Test.Tasty.Providers.ConsoleFormat
    Test.Tasty.Runners

hidden-modules:
    Control.Concurrent.Async Test.Tasty.Parallel Test.Tasty.Core
    Test.Tasty.Options.Core Test.Tasty.Options.Env Test.Tasty.Patterns
    Test.Tasty.Patterns.Expr Test.Tasty.Run Test.Tasty.Runners.Reducers
    Test.Tasty.Runners.Utils Test.Tasty.CmdLine
    Test.Tasty.Ingredients.ListTests
    Test.Tasty.Ingredients.IncludingOptions

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tasty-1.4.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tasty-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tasty
hs-libraries:         HStasty-1.4.3-2gR9WDhWbJHGLAofnQHAx7
depends:
    ansi-terminal-0.11.5-FgXvUwo3mIX2g72exyhUhE base-4.16.4.0
    containers-0.6.5.1
    optparse-applicative-0.17.1.0-AgMeQrX7nmlDOnX2xcegDb stm-2.5.0.2
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg transformers-0.5.6.2
    unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-tasty/html/tasty.haddock
haddock-html:         /usr/share/doc/haskell-tasty/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

