#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-HEXCOA1eeic2U701InupI7
key:                  tamarin-prover-utils-1.10.0-HEXCOA1eeic2U701InupI7
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  b214de8ed3e7d4614eb6d6de8b352262
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tamarin-prover-utils-1.10.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tamarin-prover-utils-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-HEXCOA1eeic2U701InupI7
depends:
    SHA-1.6.4.4-4vZ3YEU9upt6TqgW7hflaa base-4.16.4.0
    base64-bytestring-1.2.1.0-74HkITi20nv2BdJvE3AKcV binary-0.8.9.0
    blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK bytestring-0.11.4.0
    containers-0.6.5.1 deepseq-1.4.6.1 dlist-1.0-HCxoMn9TirQDgPCFxho7O
    exceptions-0.10.4 fclabels-2.0.5.1-2NJvI00NkNYAiuZQmUNzBC
    graphviz-2999.20.2.0-6pllCbdXTJp7LT0fE5yIn
    list-t-1.0.5.5-APPwcQKq0nc7dyX80RksUZ mtl-2.2.2 pretty-1.1.3.6
    safe-0.3.21-JdttgF4acvJfVRaNLAh split-0.2.5-Gzu4NbNnTUj6rs5DfMztSh
    syb-0.7.2.4-96PLGA9ePRoKEvwVQEltSr text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

