#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-sapic
version:              1.10.0
visibility:           public
id:                   tamarin-prover-sapic-1.10.0-549yoZCcy1JKQOqXdI8Moh
key:                  tamarin-prover-sapic-1.10.0-549yoZCcy1JKQOqXdI8Moh
license:              LicenseRef-GPL
copyright:
    Robert Künnemann, Alexander Dax, CISPA-Helmholtz-Centre Saarbrücken, 2019

maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Alexander Dax <alexander.dax@cispa.saarland>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Library for input processes in SAPIC calculus for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides a translation from processes stated in the SAPIC calculus into multiset rewrite rules.

category:             Theorem Provers
abi:                  0b55c4ef368751fd369d49a1a32755c0
exposed:              True
exposed-modules:
    Sapic Sapic.Annotation Sapic.Basetranslation Sapic.Bindings
    Sapic.Compression Sapic.Exceptions Sapic.Facts Sapic.LetDestructors
    Sapic.Locks Sapic.ProcessUtils Sapic.ProgressFunction
    Sapic.ProgressTranslation Sapic.ReliableChannelTranslation
    Sapic.Report Sapic.SecretChannels Sapic.States Sapic.Typing
    Sapic.Warnings

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tamarin-prover-sapic-1.10.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tamarin-prover-sapic-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-sapic
hs-libraries:         HStamarin-prover-sapic-1.10.0-549yoZCcy1JKQOqXdI8Moh
depends:
    aeson-2.1.2.1-I893iKJ0oHPJ1jEwOVWed6
    aeson-pretty-0.8.10-1w3bzFq1eKcCRjNt7mV0fD base-4.16.4.0
    binary-0.8.9.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 dlist-1.0-HCxoMn9TirQDgPCFxho7O exceptions-0.10.4
    fclabels-2.0.5.1-2NJvI00NkNYAiuZQmUNzBC mtl-2.2.2
    parallel-3.2.2.0-KgDyPHm89eYAjQsIhXthC1 parsec-3.1.15.0
    process-1.6.16.0 raw-strings-qq-1.1-VApnGDkS2kGDwmKDL5Udj
    safe-0.3.21-JdttgF4acvJfVRaNLAh
    tamarin-prover-term-1.10.0-8TUBlin4glxGRjENfN4dn8
    tamarin-prover-theory-1.10.0-8QmWNw4NaGOHVMSqEv8teV
    tamarin-prover-utils-1.10.0-HEXCOA1eeic2U701InupI7 text-1.2.5.0
    transformers-0.5.6.2 uniplate-1.6.13-AjSqydB1rb24oLC5xoUisy

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-sapic/html/tamarin-prover-sapic.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-sapic/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

